/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.dircache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrewrite.shaded.jgit.api.errors.CanceledException;
import org.openrewrite.shaded.jgit.api.errors.FilterFailedException;
import org.openrewrite.shaded.jgit.attributes.FilterCommand;
import org.openrewrite.shaded.jgit.attributes.FilterCommandRegistry;
import org.openrewrite.shaded.jgit.dircache.DirCache;
import org.openrewrite.shaded.jgit.dircache.DirCacheBuildIterator;
import org.openrewrite.shaded.jgit.dircache.DirCacheBuilder;
import org.openrewrite.shaded.jgit.dircache.DirCacheEntry;
import org.openrewrite.shaded.jgit.dircache.DirCacheIterator;
import org.openrewrite.shaded.jgit.dircache.InvalidPathException;
import org.openrewrite.shaded.jgit.errors.CheckoutConflictException;
import org.openrewrite.shaded.jgit.errors.CorruptObjectException;
import org.openrewrite.shaded.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.shaded.jgit.errors.IndexWriteException;
import org.openrewrite.shaded.jgit.errors.MissingObjectException;
import org.openrewrite.shaded.jgit.events.WorkingTreeModifiedEvent;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.CoreConfig;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.lib.NullProgressMonitor;
import org.openrewrite.shaded.jgit.lib.ObjectChecker;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectLoader;
import org.openrewrite.shaded.jgit.lib.ObjectReader;
import org.openrewrite.shaded.jgit.lib.ProgressMonitor;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.shaded.jgit.treewalk.CanonicalTreeParser;
import org.openrewrite.shaded.jgit.treewalk.EmptyTreeIterator;
import org.openrewrite.shaded.jgit.treewalk.FileTreeIterator;
import org.openrewrite.shaded.jgit.treewalk.NameConflictTreeWalk;
import org.openrewrite.shaded.jgit.treewalk.TreeWalk;
import org.openrewrite.shaded.jgit.treewalk.WorkingTreeIterator;
import org.openrewrite.shaded.jgit.treewalk.WorkingTreeOptions;
import org.openrewrite.shaded.jgit.treewalk.filter.PathFilter;
import org.openrewrite.shaded.jgit.util.FS;
import org.openrewrite.shaded.jgit.util.FileUtils;
import org.openrewrite.shaded.jgit.util.IntList;
import org.openrewrite.shaded.jgit.util.RawParseUtils;
import org.openrewrite.shaded.jgit.util.SystemReader;
import org.openrewrite.shaded.jgit.util.io.EolStreamTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirCacheCheckout {
    private static final Logger LOG = LoggerFactory.getLogger(DirCacheCheckout.class);
    private static final int MAX_EXCEPTION_TEXT_SIZE = 10240;
    private Repository repo;
    private HashMap<String, CheckoutMetadata> updated = new HashMap();
    private ArrayList<String> conflicts = new ArrayList();
    private ArrayList<String> removed = new ArrayList();
    private ArrayList<String> kept = new ArrayList();
    private ObjectId mergeCommitTree;
    private DirCache dc;
    private DirCacheBuilder builder;
    private NameConflictTreeWalk walk;
    private ObjectId headCommitTree;
    private WorkingTreeIterator workingTree;
    private boolean failOnConflict = true;
    private boolean force = false;
    private ArrayList<String> toBeDeleted = new ArrayList();
    private boolean initialCheckout;
    private boolean performingCheckout;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    public Map<String, CheckoutMetadata> getUpdated() {
        return this.updated;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public List<String> getToBeDeleted() {
        return this.toBeDeleted;
    }

    public List<String> getRemoved() {
        return this.removed;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this.repo = repo;
        this.dc = dc;
        this.headCommitTree = headCommitTree;
        this.mergeCommitTree = mergeCommitTree;
        this.workingTree = workingTree;
        this.initialCheckout = !repo.isBare() && !repo.getIndexFile().exists();
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, headCommitTree, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, workingTree);
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor != null ? monitor : NullProgressMonitor.INSTANCE;
    }

    public void preScanTwoTrees() throws CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.builder = this.dc.builder();
        this.addTree(this.walk, this.headCommitTree);
        this.addTree(this.walk, this.mergeCommitTree);
        int dciPos = this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        this.workingTree.setDirCacheIterator(this.walk, dciPos);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, CanonicalTreeParser.class), this.walk.getTree(2, DirCacheBuildIterator.class), this.walk.getTree(3, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
    }

    private void addTree(TreeWalk tw, ObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (id == null) {
            tw.addTree(new EmptyTreeIterator());
        } else {
            tw.addTree(id);
        }
    }

    public void prescanOneTree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.builder = this.dc.builder();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.addTree(this.walk, this.mergeCommitTree);
        int dciPos = this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        this.workingTree.setDirCacheIterator(this.walk, dciPos);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, DirCacheBuildIterator.class), this.walk.getTree(2, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
        this.conflicts.removeAll(this.removed);
    }

    void processEntry(CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f) throws IOException {
        if (m != null) {
            DirCacheCheckout.checkValidPath(m);
            if (i == null) {
                if (f != null && !FileMode.TREE.equals(f.getEntryFileMode()) && !f.isEntryIgnored()) {
                    if (this.failOnConflict) {
                        this.conflicts.add(this.walk.getPathString());
                    } else {
                        this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                    }
                } else {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                }
            } else if (f == null || !m.idEqual(i)) {
                this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
            } else if (i.getDirCacheEntry() != null) {
                if (f.isModified(i.getDirCacheEntry(), true, this.walk.getObjectReader()) || i.getDirCacheEntry().getStage() != 0) {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                } else {
                    DirCacheEntry entry = i.getDirCacheEntry();
                    Instant mtime = entry.getLastModifiedInstant();
                    if (mtime == null || mtime.equals(Instant.EPOCH)) {
                        entry.setLastModified(f.getEntryLastModifiedInstant());
                    }
                    this.keep(i.getEntryPathString(), entry, f);
                }
            } else {
                this.keep(i.getEntryPathString(), i.getDirCacheEntry(), f);
            }
        } else if (f != null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflicts.add(this.walk.getPathString());
            } else if (i != null) {
                this.remove(i.getEntryPathString());
                this.conflicts.remove(i.getEntryPathString());
            }
        }
    }

    public boolean checkout() throws IOException {
        try {
            boolean bl = this.doCheckout();
            return bl;
        }
        catch (CanceledException ce) {
            throw new IOException(ce);
        }
        finally {
            try {
                this.dc.unlock();
            }
            finally {
                if (this.performingCheckout) {
                    HashSet<String> touched = new HashSet<String>(this.conflicts);
                    touched.addAll(this.getUpdated().keySet());
                    touched.addAll(this.kept);
                    WorkingTreeModifiedEvent event = new WorkingTreeModifiedEvent(touched, this.getRemoved());
                    if (!event.isEmpty()) {
                        this.repo.fireEvent(event);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doCheckout() throws CorruptObjectException, IOException, MissingObjectException, IncorrectObjectTypeException, CheckoutConflictException, IndexWriteException, CanceledException {
        this.toBeDeleted.clear();
        Throwable throwable = null;
        Object var2_3 = null;
        try (ObjectReader objectReader = this.repo.getObjectDatabase().newReader();){
            block31: {
                Exception ex2;
                Map.Entry<String, CheckoutMetadata> e;
                Iterator<Map.Entry<String, CheckoutMetadata>> toUpdate;
                if (this.headCommitTree != null) {
                    this.preScanTwoTrees();
                } else {
                    this.prescanOneTree();
                }
                if (!this.conflicts.isEmpty()) {
                    if (this.failOnConflict) {
                        throw new CheckoutConflictException(this.conflicts.toArray(new String[0]));
                    }
                    this.cleanUpConflicts();
                }
                this.builder.finish();
                int numTotal = this.removed.size() + this.updated.size() + this.conflicts.size();
                this.monitor.beginTask(JGitText.get().checkingOutFiles, numTotal);
                this.performingCheckout = true;
                File file = null;
                String last = null;
                IntList nonDeleted = new IntList();
                int i = this.removed.size() - 1;
                while (true) {
                    if (i < 0) {
                        if (file != null) {
                            this.removeEmptyParents(file);
                        }
                        this.removed = DirCacheCheckout.filterOut(this.removed, nonDeleted);
                        nonDeleted = null;
                        toUpdate = this.updated.entrySet().iterator();
                        e = null;
                        try {
                            while (toUpdate.hasNext()) {
                                e = toUpdate.next();
                                String path = e.getKey();
                                CheckoutMetadata meta = e.getValue();
                                DirCacheEntry entry = this.dc.getEntry(path);
                                if (FileMode.GITLINK.equals(entry.getRawMode())) {
                                    this.checkoutGitlink(path, entry);
                                } else {
                                    DirCacheCheckout.checkoutEntry(this.repo, entry, objectReader, false, meta);
                                }
                                e = null;
                                this.monitor.update(1);
                                if (!this.monitor.isCancelled()) continue;
                                throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().checkingOutFiles));
                            }
                            break block31;
                        }
                        catch (Exception ex2) {
                            if (e == null) break;
                            toUpdate.remove();
                            break;
                        }
                    }
                    String r = this.removed.get(i);
                    file = new File(this.repo.getWorkTree(), r);
                    if (!file.delete() && this.repo.getFS().exists(file)) {
                        if (!this.repo.getFS().isDirectory(file)) {
                            nonDeleted.add(i);
                            this.toBeDeleted.add(r);
                        }
                    } else {
                        if (last != null && !DirCacheCheckout.isSamePrefix(r, last)) {
                            this.removeEmptyParents(new File(this.repo.getWorkTree(), last));
                        }
                        last = r;
                    }
                    this.monitor.update(1);
                    if (this.monitor.isCancelled()) {
                        throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().checkingOutFiles));
                    }
                    --i;
                }
                while (true) {
                    if (!toUpdate.hasNext()) {
                        throw ex2;
                    }
                    e = toUpdate.next();
                    toUpdate.remove();
                }
            }
            Iterator<String> iterator = this.conflicts.iterator();
            do {
                if (!iterator.hasNext()) {
                    this.monitor.endTask();
                    if (this.builder.commit()) return this.toBeDeleted.isEmpty();
                    throw new IndexWriteException();
                }
                String conflict = iterator.next();
                int entryIdx = this.dc.findEntry(conflict);
                if (entryIdx >= 0) {
                    DirCacheEntry entry;
                    while (entryIdx < this.dc.getEntryCount() && (entry = this.dc.getEntry(entryIdx)).getPathString().equals(conflict)) {
                        if (entry.getStage() == 3) {
                            DirCacheCheckout.checkoutEntry(this.repo, entry, objectReader, false, null);
                            break;
                        }
                        ++entryIdx;
                    }
                }
                this.monitor.update(1);
            } while (!this.monitor.isCancelled());
            throw new CanceledException(MessageFormat.format(JGitText.get().operationCanceled, JGitText.get().checkingOutFiles));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void checkoutGitlink(String path, DirCacheEntry entry) throws IOException {
        File gitlinkDir = new File(this.repo.getWorkTree(), path);
        FileUtils.mkdirs(gitlinkDir, true);
        FS fs = this.repo.getFS();
        entry.setLastModified(fs.lastModifiedInstant(gitlinkDir));
    }

    private static ArrayList<String> filterOut(ArrayList<String> strings, IntList indicesToRemove) {
        int n = indicesToRemove.size();
        if (n == strings.size()) {
            return new ArrayList<String>(0);
        }
        switch (n) {
            case 0: {
                return strings;
            }
            case 1: {
                strings.remove(indicesToRemove.get(0));
                return strings;
            }
        }
        int length = strings.size();
        ArrayList<String> result = new ArrayList<String>(length - n);
        int j = n - 1;
        int idx = indicesToRemove.get(j);
        int i = 0;
        while (i < length) {
            if (i == idx) {
                idx = --j >= 0 ? indicesToRemove.get(j) : -1;
            } else {
                result.add(strings.get(i));
            }
            ++i;
        }
        return result;
    }

    private static boolean isSamePrefix(String a, String b) {
        int as = a.lastIndexOf(47);
        int bs = b.lastIndexOf(47);
        return a.substring(0, as + 1).equals(b.substring(0, bs + 1));
    }

    private void removeEmptyParents(File f) {
        File parentFile = f.getParentFile();
        while (parentFile != null && !parentFile.equals(this.repo.getWorkTree())) {
            if (!parentFile.delete()) break;
            parentFile = parentFile.getParentFile();
        }
    }

    private boolean equalIdAndMode(ObjectId id1, FileMode mode1, ObjectId id2, FileMode mode2) {
        if (!mode1.equals(mode2)) {
            return false;
        }
        return id1 != null ? id1.equals(id2) : id2 == null;
    }

    void processEntry(CanonicalTreeParser h, CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f) throws IOException {
        DirCacheEntry dce = i != null ? i.getDirCacheEntry() : null;
        String name = this.walk.getPathString();
        if (m != null) {
            DirCacheCheckout.checkValidPath(m);
        }
        if (i == null && m == null && h == null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflict(name, null, null, null);
            }
            return;
        }
        ObjectId iId = i == null ? null : i.getEntryObjectId();
        ObjectId mId = m == null ? null : m.getEntryObjectId();
        ObjectId hId = h == null ? null : h.getEntryObjectId();
        FileMode iMode = i == null ? null : i.getEntryFileMode();
        FileMode mMode = m == null ? null : m.getEntryFileMode();
        FileMode hMode = h == null ? null : h.getEntryFileMode();
        int ffMask = 0;
        if (h != null) {
            int n = ffMask = FileMode.TREE.equals(hMode) ? 3328 : 3840;
        }
        if (i != null) {
            ffMask |= FileMode.TREE.equals(iMode) ? 208 : 240;
        }
        if (m != null) {
            ffMask |= FileMode.TREE.equals(mMode) ? 13 : 15;
        }
        if ((ffMask & 0x222) != 0 && ((ffMask & 0xF) == 13 || (ffMask & 0xF0) == 208 || (ffMask & 0xF00) == 3328)) {
            switch (ffMask) {
                case 3551: {
                    if (f != null && this.isModifiedSubtree_IndexWorkingtree(name)) {
                        this.conflict(name, dce, h, m);
                        break;
                    }
                    this.update(name, mId, mMode);
                    break;
                }
                case 3581: {
                    this.keep(name, dce, f);
                    break;
                }
                case 3853: {
                    this.remove(name);
                    break;
                }
                case 3583: {
                    if (this.equalIdAndMode(iId, iMode, mId, mMode)) {
                        this.keep(name, dce, f);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 4061: {
                    break;
                }
                case 3343: {
                    this.update(name, mId, mMode);
                    break;
                }
                case 253: 
                case 3568: {
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 4063: {
                    if (this.equalIdAndMode(hId, hMode, mId, mMode)) {
                        if (this.isModifiedSubtree_IndexWorkingtree(name)) {
                            this.conflict(name, dce, h, m);
                            break;
                        }
                        this.update(name, mId, mMode);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 4048: {
                    this.keep(name, dce, f);
                    break;
                }
                case 4093: {
                    if (this.equalIdAndMode(hId, hMode, iId, iMode)) {
                        if (f != null && f.isModified(dce, true, this.walk.getObjectReader())) {
                            this.conflict(name, dce, h, m);
                            break;
                        }
                        this.remove(name);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 223: {
                    if (!this.isModifiedSubtree_IndexWorkingtree(name)) {
                        this.update(name, mId, mMode);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                default: {
                    this.keep(name, dce, f);
                }
            }
            return;
        }
        if ((ffMask & 0x222) == 0) {
            if (f == null || FileMode.TREE.equals(f.getEntryFileMode())) {
                return;
            }
            if (!DirCacheCheckout.idEqual(h, m)) {
                this.conflict(name, null, null, null);
            }
            return;
        }
        if (ffMask == 15 && f != null && FileMode.TREE.equals(f.getEntryFileMode())) {
            this.conflict(name, null, h, m);
            return;
        }
        if (i == null) {
            if (!(f == null || f.isEntryIgnored() || FileMode.GITLINK.equals(mMode) || mId != null && this.equalIdAndMode(mId, mMode, f.getEntryObjectId(), f.getEntryFileMode()))) {
                this.conflict(name, null, h, m);
                return;
            }
            if (h == null) {
                this.update(name, mId, mMode);
            } else if (m == null) {
                this.remove(name);
            } else if (this.equalIdAndMode(hId, hMode, mId, mMode)) {
                if (this.initialCheckout || this.force) {
                    this.update(name, mId, mMode);
                } else {
                    this.keep(name, dce, f);
                }
            } else {
                this.conflict(name, dce, h, m);
            }
        } else if (h == null) {
            if (m == null || !this.isModified_IndexTree(name, iId, iMode, mId, mMode, this.mergeCommitTree)) {
                if (m == null && this.walk.isDirectoryFileConflict()) {
                    if (dce != null && (f == null || f.isModified(dce, true, this.walk.getObjectReader()))) {
                        this.conflict(name, dce, h, m);
                    } else {
                        this.remove(name);
                    }
                } else {
                    this.keep(name, dce, f);
                }
            } else {
                this.conflict(name, dce, h, m);
            }
        } else if (m == null) {
            if (iMode == FileMode.GITLINK) {
                this.remove(name);
            } else if (!this.isModified_IndexTree(name, iId, iMode, hId, hMode, this.headCommitTree)) {
                if (f != null && f.isModified(dce, true, this.walk.getObjectReader())) {
                    if (!FileMode.TREE.equals(f.getEntryFileMode()) && FileMode.TREE.equals(iMode)) {
                        return;
                    }
                    this.conflict(name, dce, h, m);
                } else {
                    this.remove(name);
                }
            } else {
                this.conflict(name, dce, h, m);
            }
        } else if (!this.equalIdAndMode(hId, hMode, mId, mMode) && this.isModified_IndexTree(name, iId, iMode, hId, hMode, this.headCommitTree) && this.isModified_IndexTree(name, iId, iMode, mId, mMode, this.mergeCommitTree)) {
            this.conflict(name, dce, h, m);
        } else if (!this.isModified_IndexTree(name, iId, iMode, hId, hMode, this.headCommitTree) && this.isModified_IndexTree(name, iId, iMode, mId, mMode, this.mergeCommitTree)) {
            if (dce != null && FileMode.GITLINK.equals(dce.getFileMode())) {
                this.update(name, mId, mMode);
            } else if (dce != null && f != null && f.isModified(dce, true, this.walk.getObjectReader())) {
                this.conflict(name, dce, h, m);
            } else {
                this.update(name, mId, mMode);
            }
        } else {
            this.keep(name, dce, f);
        }
    }

    private static boolean idEqual(AbstractTreeIterator a, AbstractTreeIterator b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getEntryObjectId().equals(b.getEntryObjectId());
    }

    private void conflict(String path, DirCacheEntry e, AbstractTreeIterator h, AbstractTreeIterator m) {
        DirCacheEntry entry;
        this.conflicts.add(path);
        if (e != null) {
            entry = new DirCacheEntry(e.getPathString(), 1);
            entry.copyMetaData(e, true);
            this.builder.add(entry);
        }
        if (h != null && !FileMode.TREE.equals(h.getEntryFileMode())) {
            entry = new DirCacheEntry(h.getEntryPathString(), 2);
            entry.setFileMode(h.getEntryFileMode());
            entry.setObjectId(h.getEntryObjectId());
            this.builder.add(entry);
        }
        if (m != null && !FileMode.TREE.equals(m.getEntryFileMode())) {
            entry = new DirCacheEntry(m.getEntryPathString(), 3);
            entry.setFileMode(m.getEntryFileMode());
            entry.setObjectId(m.getEntryObjectId());
            this.builder.add(entry);
        }
    }

    private void keep(String path, DirCacheEntry e, WorkingTreeIterator f) throws IOException {
        if (e == null) {
            return;
        }
        if (!FileMode.TREE.equals(e.getFileMode())) {
            this.builder.add(e);
        }
        if (this.force && (f == null || f.isModified(e, true, this.walk.getObjectReader()))) {
            this.kept.add(path);
            DirCacheCheckout.checkoutEntry(this.repo, e, this.walk.getObjectReader(), false, new CheckoutMetadata(this.walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP), this.walk.getFilterCommand("smudge")));
        }
    }

    private void remove(String path) {
        this.removed.add(path);
    }

    private void update(String path, ObjectId mId, FileMode mode) throws IOException {
        if (!FileMode.TREE.equals(mode)) {
            this.updated.put(path, new CheckoutMetadata(this.walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP), this.walk.getFilterCommand("smudge")));
            DirCacheEntry entry = new DirCacheEntry(path, 0);
            entry.setObjectId(mId);
            entry.setFileMode(mode);
            this.builder.add(entry);
        }
    }

    public void setFailOnConflict(boolean failOnConflict) {
        this.failOnConflict = failOnConflict;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    private void cleanUpConflicts() throws CheckoutConflictException {
        for (String c : this.conflicts) {
            File conflict = new File(this.repo.getWorkTree(), c);
            if (!conflict.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, c));
            }
            this.removeEmptyParents(conflict);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModifiedSubtree_IndexWorkingtree(String path) throws CorruptObjectException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);){
            DirCacheIterator dcIt;
            WorkingTreeIterator wtIt;
            int dciPos = tw.addTree(new DirCacheIterator(this.dc));
            FileTreeIterator fti = new FileTreeIterator(this.repo);
            tw.addTree(fti);
            fti.setDirCacheIterator(tw, dciPos);
            tw.setRecursive(true);
            tw.setFilter(PathFilter.create(path));
            do {
                if (!tw.next()) {
                    return false;
                }
                dcIt = tw.getTree(0, DirCacheIterator.class);
                wtIt = tw.getTree(1, WorkingTreeIterator.class);
                if (dcIt == null) return true;
                if (wtIt != null) continue;
                return true;
            } while (!wtIt.isModified(dcIt.getDirCacheEntry(), true, this.walk.getObjectReader()));
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private boolean isModified_IndexTree(String path, ObjectId iId, FileMode iMode, ObjectId tId, FileMode tMode, ObjectId rootTree) throws CorruptObjectException, IOException {
        if (iMode != tMode) {
            return true;
        }
        if (FileMode.TREE.equals(iMode) && (iId == null || ObjectId.zeroId().equals(iId))) {
            return this.isModifiedSubtree_IndexTree(path, rootTree);
        }
        return !this.equalIdAndMode(iId, iMode, tId, tMode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModifiedSubtree_IndexTree(String path, ObjectId tree) throws CorruptObjectException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);){
            AbstractTreeIterator treeIt;
            DirCacheIterator dcIt;
            tw.addTree(new DirCacheIterator(this.dc));
            tw.addTree(tree);
            tw.setRecursive(true);
            tw.setFilter(PathFilter.create(path));
            do {
                if (!tw.next()) {
                    return false;
                }
                dcIt = tw.getTree(0, DirCacheIterator.class);
                treeIt = tw.getTree(1, AbstractTreeIterator.class);
                if (dcIt == null) return true;
                if (treeIt == null) {
                    return true;
                }
                if (dcIt.getEntryRawMode() == treeIt.getEntryRawMode()) continue;
                return true;
            } while (dcIt.getEntryObjectId().equals(treeIt.getEntryObjectId()));
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Deprecated
    public static void checkoutEntry(Repository repo, DirCacheEntry entry, ObjectReader or) throws IOException {
        DirCacheCheckout.checkoutEntry(repo, entry, or, false, null);
    }

    public static void checkoutEntry(Repository repo, DirCacheEntry entry, ObjectReader or, boolean deleteRecursive, CheckoutMetadata checkoutMetadata) throws IOException {
        if (checkoutMetadata == null) {
            checkoutMetadata = CheckoutMetadata.EMPTY;
        }
        ObjectLoader ol = or.open(entry.getObjectId());
        File f = new File(repo.getWorkTree(), entry.getPathString());
        File parentDir = f.getParentFile();
        if (parentDir.isFile()) {
            FileUtils.delete(parentDir);
        }
        FileUtils.mkdirs(parentDir, true);
        FS fs = repo.getFS();
        WorkingTreeOptions opt = repo.getConfig().get(WorkingTreeOptions.KEY);
        if (entry.getFileMode() == FileMode.SYMLINK && opt.getSymLinks() == CoreConfig.SymLinks.TRUE) {
            byte[] bytes = ol.getBytes();
            String target = RawParseUtils.decode(bytes);
            if (deleteRecursive && f.isDirectory()) {
                FileUtils.delete(f, 1);
            }
            fs.createSymLink(f, target);
            entry.setLength(bytes.length);
            entry.setLastModified(fs.lastModifiedInstant(f));
            return;
        }
        String name = f.getName();
        if (name.length() > 200) {
            name = name.substring(0, 200);
        }
        File tmpFile = File.createTempFile("._" + name, null, parentDir);
        DirCacheCheckout.getContent(repo, entry.getPathString(), checkoutMetadata, ol, opt, new FileOutputStream(tmpFile));
        if (checkoutMetadata.eolStreamType == CoreConfig.EolStreamType.DIRECT && checkoutMetadata.smudgeFilterCommand == null) {
            entry.setLength(ol.getSize());
        } else {
            entry.setLength(tmpFile.length());
        }
        if (opt.isFileMode() && fs.supportsExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(entry.getRawMode())) {
                if (!fs.canExecute(tmpFile)) {
                    fs.setExecute(tmpFile, true);
                }
            } else if (fs.canExecute(tmpFile)) {
                fs.setExecute(tmpFile, false);
            }
        }
        try {
            try {
                if (deleteRecursive && f.isDirectory()) {
                    FileUtils.delete(f, 1);
                }
                FileUtils.rename(tmpFile, f, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, tmpFile.getPath(), f.getPath()), e);
            }
        }
        finally {
            if (tmpFile.exists()) {
                FileUtils.delete(tmpFile);
            }
        }
        entry.setLastModified(fs.lastModifiedInstant(f));
    }

    public static void getContent(Repository repo, String path, CheckoutMetadata checkoutMetadata, ObjectLoader ol, WorkingTreeOptions opt, OutputStream os) throws IOException {
        CoreConfig.EolStreamType nonNullEolStreamType = checkoutMetadata.eolStreamType != null ? checkoutMetadata.eolStreamType : (opt.getAutoCRLF() == CoreConfig.AutoCRLF.TRUE ? CoreConfig.EolStreamType.AUTO_CRLF : CoreConfig.EolStreamType.DIRECT);
        Throwable throwable = null;
        Object var8_9 = null;
        try (OutputStream channel = EolStreamTypeUtil.wrapOutputStream(os, nonNullEolStreamType);){
            if (checkoutMetadata.smudgeFilterCommand != null) {
                if (FilterCommandRegistry.isRegistered(checkoutMetadata.smudgeFilterCommand)) {
                    DirCacheCheckout.runBuiltinFilterCommand(repo, checkoutMetadata, ol, channel);
                } else {
                    DirCacheCheckout.runExternalFilterCommand(repo, path, checkoutMetadata, ol, channel);
                }
            } else {
                ol.copyTo(channel);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void runExternalFilterCommand(Repository repo, String path, CheckoutMetadata checkoutMetadata, ObjectLoader ol, OutputStream channel) throws IOException {
        int rc;
        FS.ExecutionResult result;
        FS fs = repo.getFS();
        ProcessBuilder filterProcessBuilder = fs.runInShell(checkoutMetadata.smudgeFilterCommand, new String[0]);
        filterProcessBuilder.directory(repo.getWorkTree());
        filterProcessBuilder.environment().put("GIT_DIR", repo.getDirectory().getAbsolutePath());
        try {
            result = fs.execute(filterProcessBuilder, ol.openStream());
            rc = result.getRc();
            if (rc == 0) {
                result.getStdout().writeTo(channel, NullProgressMonitor.INSTANCE);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new IOException(new FilterFailedException(e, checkoutMetadata.smudgeFilterCommand, path));
        }
        if (rc != 0) {
            throw new IOException(new FilterFailedException(rc, checkoutMetadata.smudgeFilterCommand, path, result.getStdout().toByteArray(10240), RawParseUtils.decode(result.getStderr().toByteArray(10240))));
        }
    }

    private static void runBuiltinFilterCommand(Repository repo, CheckoutMetadata checkoutMetadata, ObjectLoader ol, OutputStream channel) throws MissingObjectException, IOException {
        boolean isMandatory = repo.getConfig().getBoolean("filter", "lfs", "required", false);
        FilterCommand command = null;
        try {
            command = FilterCommandRegistry.createFilterCommand(checkoutMetadata.smudgeFilterCommand, repo, ol.openStream(), channel);
        }
        catch (IOException e) {
            LOG.error(JGitText.get().failedToDetermineFilterDefinition, (Throwable)e);
            if (!isMandatory) {
                ol.copyTo(channel);
            }
            throw e;
        }
        if (command != null) {
            while (command.run() != -1) {
            }
        }
    }

    private static void checkValidPath(CanonicalTreeParser t) throws InvalidPathException {
        ObjectChecker chk = new ObjectChecker().setSafeForWindows(SystemReader.getInstance().isWindows()).setSafeForMacOS(SystemReader.getInstance().isMacOS());
        CanonicalTreeParser i = t;
        while (i != null) {
            DirCacheCheckout.checkValidPathSegment(chk, i);
            i = i.getParent();
        }
    }

    private static void checkValidPathSegment(ObjectChecker chk, CanonicalTreeParser t) throws InvalidPathException {
        try {
            int ptr = t.getNameOffset();
            int end = ptr + t.getNameLength();
            chk.checkPathSegment(t.getEntryPathBuffer(), ptr, end);
        }
        catch (CorruptObjectException err) {
            String path = t.getEntryPathString();
            InvalidPathException i = new InvalidPathException(path);
            i.initCause(err);
            throw i;
        }
    }

    public static class CheckoutMetadata {
        public final CoreConfig.EolStreamType eolStreamType;
        public final String smudgeFilterCommand;
        static CheckoutMetadata EMPTY = new CheckoutMetadata(CoreConfig.EolStreamType.DIRECT, null);

        public CheckoutMetadata(CoreConfig.EolStreamType eolStreamType, String smudgeFilterCommand) {
            this.eolStreamType = eolStreamType;
            this.smudgeFilterCommand = smudgeFilterCommand;
        }
    }
}

