/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.NullUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public abstract class Recipe {
    private static final Logger logger = LoggerFactory.getLogger(Recipe.class);
    private static final TreePrinter<ExecutionContext> MARKER_ID_PRINTER = new TreePrinter<ExecutionContext>(){

        @Override
        public void doBefore(@Nullable Tree tree, StringBuilder printerAcc, ExecutionContext executionContext) {
            String markerIds;
            if (tree != null && !(markerIds = tree.getMarkers().entries().stream().filter(marker -> !(marker instanceof RecipeThatMadeChanges)).map(marker -> String.valueOf(marker.hashCode())).collect(Collectors.joining(","))).isEmpty()) {
                printerAcc.append("markers[").append(markerIds).append("]->");
            }
        }
    };
    public static final TreeVisitor<?, ExecutionContext> NOOP = new TreeVisitor<Tree, ExecutionContext>(){

        @Override
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return tree;
        }
    };
    @JsonIgnore
    private final List<Recipe> recipeList = new ArrayList<Recipe>();

    @JsonProperty(value="@c")
    public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    public abstract String getDisplayName();

    public String getDescription() {
        return "";
    }

    public Set<String> getTags() {
        return Collections.emptySet();
    }

    public final RecipeDescriptor getDescriptor() {
        return RecipeIntrospectionUtils.recipeDescriptorFromRecipe(this);
    }

    public List<String> getLanguages() {
        return Collections.emptyList();
    }

    public Recipe doNext(Recipe recipe) {
        this.recipeList.add(recipe);
        return this;
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return NOOP;
    }

    private <S extends SourceFile> List<SourceFile> visitInternal(List<S> before, ExecutionContext ctx, ForkJoinPool forkJoinPool, Map<UUID, Recipe> recipeThatDeletedSourceFile) {
        List<SourceFile> after = before;
        if (this.validate(ctx).isValid()) {
            after = ListUtils.map(after, forkJoinPool, s -> {
                Timer.Builder timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", this.getDisplayName());
                Timer.Sample sample = Timer.start();
                try {
                    SourceFile afterFile = (SourceFile)this.getVisitor().visit((Tree)s, ctx);
                    if (afterFile != null && afterFile != s) {
                        afterFile = (SourceFile)afterFile.withMarkers(afterFile.getMarkers().compute(new RecipeThatMadeChanges(this), (r1, r2) -> {
                            ((RecipeThatMadeChanges)r1).recipes.addAll(((RecipeThatMadeChanges)r2).recipes);
                            return r1;
                        }));
                        sample.stop(timer.tags(new String[]{"outcome", "changed", "exception", "none"}).register((MeterRegistry)Metrics.globalRegistry));
                    } else if (afterFile == null) {
                        recipeThatDeletedSourceFile.put(s.getId(), this);
                        sample.stop(timer.tags(new String[]{"outcome", "deleted", "exception", "none"}).register((MeterRegistry)Metrics.globalRegistry));
                    } else {
                        sample.stop(timer.tags(new String[]{"outcome", "unchanged", "exception", "none"}).register((MeterRegistry)Metrics.globalRegistry));
                    }
                    return afterFile;
                }
                catch (Throwable t) {
                    sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
                    ctx.getOnError().accept(t);
                    return s;
                }
            });
        }
        List<SourceFile> afterWidened = this.visit(after, ctx);
        for (SourceFile maybeGenerated : afterWidened) {
            if (after.contains(maybeGenerated)) continue;
            recipeThatDeletedSourceFile.put(maybeGenerated.getId(), this);
        }
        for (SourceFile maybeDeleted : after) {
            if (afterWidened.contains(maybeDeleted)) continue;
            recipeThatDeletedSourceFile.put(maybeDeleted.getId(), this);
        }
        for (Recipe recipe : this.recipeList) {
            afterWidened = recipe.visitInternal(afterWidened, ctx, forkJoinPool, recipeThatDeletedSourceFile);
        }
        return afterWidened;
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        return before;
    }

    public final List<Result> run(List<? extends SourceFile> before) {
        return this.run(before, new InMemoryExecutionContext());
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx) {
        return this.run(before, ctx, 3);
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles) {
        return this.run(before, ctx, ForkJoinPool.commonPool(), maxCycles);
    }

    public final List<Result> run(List<? extends SourceFile> before, ExecutionContext ctx, ForkJoinPool forkJoinPool, int maxCycles) {
        List<? extends SourceFile> acc;
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", this.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Recipe> recipeThatDeletedSourceFile = new HashMap<UUID, Recipe>();
        List<? extends SourceFile> after = acc = before;
        WatchForNewMessageExecutionContext ctxWithWatch = new WatchForNewMessageExecutionContext(ctx);
        for (int i = 0; i < maxCycles && ((after = this.visitInternal(acc, ctxWithWatch, forkJoinPool, recipeThatDeletedSourceFile)) != acc || ctxWithWatch.needAnotherCycle); ++i) {
            acc = after;
            ctxWithWatch.needAnotherCycle = false;
        }
        if (after == before) {
            return Collections.emptyList();
        }
        Map sourceFileIdentities = before.stream().collect(Collectors.toMap(Tree::getId, Function.identity()));
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile : after) {
            SourceFile sourceFile2 = (SourceFile)sourceFileIdentities.get(sourceFile.getId());
            if (sourceFile2 == sourceFile) continue;
            if (sourceFile2 == null) {
                results.add(new Result(null, sourceFile, Collections.singleton((Recipe)recipeThatDeletedSourceFile.get(sourceFile.getId()))));
                continue;
            }
            if (sourceFile2.print(MARKER_ID_PRINTER, ctx).equals(sourceFile.print(MARKER_ID_PRINTER, ctx))) continue;
            results.add(new Result(sourceFile2, sourceFile, sourceFile.getMarkers().findFirst(RecipeThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change?")).recipes));
        }
        Set afterIds = after.stream().map(Tree::getId).collect(Collectors.toSet());
        for (SourceFile sourceFile : before) {
            if (afterIds.contains(sourceFile.getId())) continue;
            results.add(new Result(sourceFile, null, Collections.singleton((Recipe)recipeThatDeletedSourceFile.get(sourceFile.getId()))));
        }
        return results;
    }

    @Incubating(since="7.0.0")
    public Validated validate(ExecutionContext ctx) {
        return this.validate();
    }

    public Validated validate() {
        Validated validated = Validated.none();
        List<Field> requiredFields = NullUtils.findNonNullFields(this.getClass());
        for (Field field : requiredFields) {
            try {
                validated = validated.and(Validated.required(field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Unable to validate the field [{}] on the class [{}]", (Object)field.getName(), (Object)this.getClass().getName());
            }
        }
        return validated;
    }

    @Incubating(since="7.0.0")
    public final Collection<Validated> validateAll(ExecutionContext ctx) {
        return this.validateAll(ctx, new ArrayList<Validated>());
    }

    public final Collection<Validated> validateAll() {
        return this.validateAll(new InMemoryExecutionContext(), new ArrayList<Validated>());
    }

    private Collection<Validated> validateAll(ExecutionContext ctx, Collection<Validated> acc) {
        acc.add(this.validate(ctx));
        for (Recipe recipe : this.recipeList) {
            recipe.validateAll(ctx, acc);
        }
        return acc;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    private static class WatchForNewMessageExecutionContext
    implements ExecutionContext {
        private boolean needAnotherCycle = true;
        private final ExecutionContext delegate;

        private WatchForNewMessageExecutionContext(ExecutionContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public void putMessage(String key, Object value) {
            this.needAnotherCycle = true;
            this.delegate.putMessage(key, value);
        }

        @Override
        @Nullable
        public <T> T getMessage(String key) {
            return this.delegate.getMessage(key);
        }

        @Override
        @Nullable
        public <T> T pollMessage(String key) {
            return this.delegate.pollMessage(key);
        }

        @Override
        public Consumer<Throwable> getOnError() {
            return this.delegate.getOnError();
        }
    }

    private static class RecipeThatMadeChanges
    implements Marker {
        private final Set<Recipe> recipes = new HashSet<Recipe>();

        private RecipeThatMadeChanges(Recipe recipe) {
            this.recipes.add(recipe);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecipeThatMadeChanges)) {
                return false;
            }
            RecipeThatMadeChanges other = (RecipeThatMadeChanges)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Recipe> this$recipes = this.recipes;
            Set<Recipe> other$recipes = other.recipes;
            return !(this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof RecipeThatMadeChanges;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Recipe> $recipes = this.recipes;
            result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
            return result;
        }
    }
}

