/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import org.openrewrite.shaded.jgit.errors.PackInvalidException;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsBlock;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsBlockCache;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsPackDescription;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsReader;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsStreamKey;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsText;
import org.openrewrite.shaded.jgit.internal.storage.dfs.ReadableChannel;
import org.openrewrite.shaded.jgit.internal.storage.pack.PackExt;

abstract class BlockBasedFile {
    final DfsBlockCache cache;
    final DfsStreamKey key;
    final DfsPackDescription desc;
    final PackExt ext;
    volatile int blockSize;
    volatile long length;
    volatile boolean invalid;
    protected volatile Exception invalidatingCause;

    BlockBasedFile(DfsBlockCache cache, DfsPackDescription desc, PackExt ext) {
        this.cache = cache;
        this.key = desc.getStreamKey(ext);
        this.desc = desc;
        this.ext = ext;
    }

    String getFileName() {
        return this.desc.getFileName(this.ext);
    }

    boolean invalid() {
        return this.invalid;
    }

    void setInvalid() {
        this.invalid = true;
    }

    void setBlockSize(int newSize) {
        this.blockSize = newSize;
    }

    long alignToBlock(long pos) {
        int size = this.blockSize;
        if (size == 0) {
            size = this.cache.getBlockSize();
        }
        return pos / (long)size * (long)size;
    }

    int blockSize(ReadableChannel rc) {
        int size = this.blockSize;
        if (size == 0) {
            size = rc.blockSize();
            if (size <= 0) {
                size = this.cache.getBlockSize();
            } else if (size < this.cache.getBlockSize()) {
                size = this.cache.getBlockSize() / size * size;
            }
            this.blockSize = size;
        }
        return size;
    }

    DfsBlock getOrLoadBlock(long pos, DfsReader ctx) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try (LazyChannel c = new LazyChannel(ctx, this.desc, this.ext);){
            return this.cache.getOrLoad(this, pos, ctx, c);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    DfsBlock readOneBlock(long pos, DfsReader ctx, ReadableChannel rc) throws IOException {
        if (this.invalid) {
            throw new PackInvalidException(this.getFileName(), (Throwable)this.invalidatingCause);
        }
        ++ctx.stats.readBlock;
        long start = System.nanoTime();
        try {
            int size = this.blockSize(rc);
            pos = pos / (long)size * (long)size;
            long len = this.length;
            if (len < 0L && 0L <= (len = rc.size())) {
                this.length = len;
            }
            if (0L <= len && len < pos + (long)size) {
                size = (int)(len - pos);
            }
            if (size <= 0) {
                throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, pos, this.getFileName(), 0L, 0L));
            }
            byte[] buf = new byte[size];
            rc.position(pos);
            int cnt = BlockBasedFile.read(rc, ByteBuffer.wrap(buf, 0, size));
            ctx.stats.readBlockBytes += (long)cnt;
            if (cnt != size) {
                if (0L <= len) {
                    throw new EOFException(MessageFormat.format(DfsText.get().shortReadOfBlock, pos, this.getFileName(), size, cnt));
                }
                byte[] n = new byte[cnt];
                System.arraycopy(buf, 0, n, 0, n.length);
                buf = n;
            } else if (len < 0L) {
                this.length = len = rc.size();
            }
            DfsBlock dfsBlock = new DfsBlock(this.key, pos, buf);
            return dfsBlock;
        }
        finally {
            ctx.stats.readBlockMicros += BlockBasedFile.elapsedMicros(start);
        }
    }

    static int read(ReadableChannel rc, ByteBuffer buf) throws IOException {
        int n;
        while ((n = rc.read(buf)) > 0 && buf.hasRemaining()) {
        }
        return buf.position();
    }

    static long elapsedMicros(long start) {
        return (System.nanoTime() - start) / 1000L;
    }

    private static class LazyChannel
    implements AutoCloseable,
    DfsBlockCache.ReadableChannelSupplier {
        private final DfsReader ctx;
        private final DfsPackDescription desc;
        private final PackExt ext;
        private ReadableChannel rc;

        LazyChannel(DfsReader ctx, DfsPackDescription desc, PackExt ext) {
            this.ctx = ctx;
            this.desc = desc;
            this.ext = ext;
        }

        @Override
        public ReadableChannel get() throws IOException {
            if (this.rc == null) {
                this.rc = this.ctx.db.openFile(this.desc, this.ext);
            }
            return this.rc;
        }

        @Override
        public void close() throws IOException {
            if (this.rc != null) {
                this.rc.close();
            }
        }
    }
}

