/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.style;

import java.util.Collection;
import java.util.Set;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.Style;

public class NamedStyles
implements Marker {
    private final String name;
    private final String displayName;
    @Nullable
    private final String description;
    private final Set<String> tags;
    private final Collection<Style> styles;

    @Nullable
    public static <S extends Style> S merge(Class<S> styleClass, Iterable<? extends NamedStyles> namedStyles) {
        Style merged = null;
        for (NamedStyles namedStyles2 : namedStyles) {
            for (Style style : namedStyles2.styles) {
                if (!styleClass.isInstance(style)) continue;
                if (merged == null) {
                    merged = style;
                    continue;
                }
                merged = merged.merge(style);
            }
        }
        return (S)merged;
    }

    public Validated validate() {
        return Validated.none();
    }

    public NamedStyles(String name, String displayName, @Nullable String description, Set<String> tags, Collection<Style> styles) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.styles = styles;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Collection<Style> getStyles() {
        return this.styles;
    }

    @NonNull
    public String toString() {
        return "NamedStyles(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", styles=" + this.getStyles() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedStyles)) {
            return false;
        }
        NamedStyles other = (NamedStyles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Collection<Style> this$styles = this.getStyles();
        Collection<Style> other$styles = other.getStyles();
        return !(this$styles == null ? other$styles != null : !((Object)this$styles).equals(other$styles));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof NamedStyles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Collection<Style> $styles = this.getStyles();
        result = result * 59 + ($styles == null ? 43 : ((Object)$styles).hashCode());
        return result;
    }
}

