/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.openrewrite.shaded.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.shaded.jgit.errors.MissingObjectException;
import org.openrewrite.shaded.jgit.lib.BitmapIndex;
import org.openrewrite.shaded.jgit.revwalk.BitmapWalker;
import org.openrewrite.shaded.jgit.revwalk.ObjectReachabilityChecker;
import org.openrewrite.shaded.jgit.revwalk.ObjectWalk;
import org.openrewrite.shaded.jgit.revwalk.RevObject;

class BitmappedObjectReachabilityChecker
implements ObjectReachabilityChecker {
    private final ObjectWalk walk;

    public BitmappedObjectReachabilityChecker(ObjectWalk walk) {
        this.walk = walk;
    }

    @Override
    public Optional<RevObject> areAllReachable(Collection<RevObject> targets, Stream<RevObject> starters) throws IOException {
        try {
            ArrayList<RevObject> remainingTargets = new ArrayList<RevObject>(targets);
            BitmapWalker bitmapWalker = new BitmapWalker(this.walk, this.walk.getObjectReader().getBitmapIndex(), null);
            Iterator starterIt = starters.iterator();
            BitmapIndex.BitmapBuilder seen = null;
            while (starterIt.hasNext()) {
                List<RevObject> asList = Arrays.asList((RevObject)starterIt.next());
                BitmapIndex.BitmapBuilder visited = bitmapWalker.findObjects(asList, seen, true);
                seen = seen == null ? visited : seen.or(visited);
                remainingTargets.removeIf(seen::contains);
                if (!remainingTargets.isEmpty()) continue;
                return Optional.empty();
            }
            return Optional.of((RevObject)remainingTargets.get(0));
        }
        catch (IncorrectObjectTypeException | MissingObjectException e) {
            throw new IllegalStateException(e);
        }
    }
}

