/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.transport.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.shaded.jgit.annotations.Nullable;
import org.openrewrite.shaded.jgit.errors.PackProtocolException;
import org.openrewrite.shaded.jgit.internal.JGitText;

public class FirstWant {
    private final String line;
    private final Set<String> capabilities;
    @Nullable
    private final String agent;
    private static final String AGENT_PREFIX = "agent=";

    public static FirstWant fromLine(String line) throws PackProtocolException {
        Set<String> capabilities;
        String wantLine;
        String agent = null;
        if (line.length() > 45) {
            String opt = line.substring(45);
            if (!opt.startsWith(" ")) {
                throw new PackProtocolException(JGitText.get().wantNoSpaceWithCapabilities);
            }
            opt = opt.substring(1);
            HashSet<String> opts = new HashSet<String>();
            String[] stringArray = opt.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String clientCapability = stringArray[n2];
                if (clientCapability.startsWith(AGENT_PREFIX)) {
                    agent = clientCapability.substring(AGENT_PREFIX.length());
                } else {
                    opts.add(clientCapability);
                }
                ++n2;
            }
            wantLine = line.substring(0, 45);
            capabilities = Collections.unmodifiableSet(opts);
        } else {
            wantLine = line;
            capabilities = Collections.emptySet();
        }
        return new FirstWant(wantLine, capabilities, agent);
    }

    private FirstWant(String line, Set<String> capabilities, @Nullable String agent) {
        this.line = line;
        this.capabilities = capabilities;
        this.agent = agent;
    }

    public String getLine() {
        return this.line;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public String getAgent() {
        return this.agent;
    }
}

