/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> mapLast(List<T> ls, Function<T, T> mapLast) {
        T newLast;
        if (ls.isEmpty()) {
            return ls;
        }
        T last = ls.get(ls.size() - 1);
        if (last != (newLast = mapLast.apply(last))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newLast == null) {
                newLs.remove(ls.size() - 1);
            } else {
                newLs.set(ls.size() - 1, newLast);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> List<T> mapFirst(List<T> ls, Function<T, T> mapFirst) {
        T newFirst;
        if (ls.isEmpty()) {
            return ls;
        }
        T first = ls.iterator().next();
        if (first != (newFirst = mapFirst.apply(first))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newFirst == null) {
                newLs.remove(0);
            } else {
                newLs.set(0, newFirst);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> List<T> map(List<T> ls, BiFunction<Integer, T, T> map) {
        if (ls.isEmpty()) {
            return ls;
        }
        List<T> newLs = ls;
        for (int i = 0; i < ls.size(); ++i) {
            T tree = ls.get(i);
            T newTree = map.apply(i, (Integer)tree);
            if (newTree == tree) continue;
            if (newLs == ls) {
                newLs = new ArrayList<T>(ls);
            }
            newLs.set(i, newTree);
        }
        if (newLs != ls) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    public static <T> List<T> map(List<T> ls, Function<T, T> map) {
        return ListUtils.map(ls, (Integer i, T t) -> map.apply(t));
    }

    public static <T> List<T> map(List<T> ls, ForkJoinPool pool, Function<T, T> map) {
        return ListUtils.map(ls, pool, (Integer i, T t) -> map.apply(t));
    }

    public static <T> List<T> map(List<T> ls, ForkJoinPool pool, BiFunction<Integer, T, T> map) {
        if (ls.isEmpty()) {
            return ls;
        }
        AtomicReference newLs = new AtomicReference(ls);
        int i = 0;
        while (i < ls.size()) {
            int index = i++;
            ForkJoinTask<?> task = ForkJoinTask.adapt(() -> {
                Object tree = ls.get(index);
                Object newTree = map.apply(index, tree);
                if (newTree != tree) {
                    ((List)newLs.updateAndGet(l -> l == ls ? new ArrayList(ls) : l)).set(index, newTree);
                }
            });
            pool.invoke(task);
            task.join();
        }
        if (newLs.get() != ls) {
            while (newLs.get().remove(null)) {
            }
        }
        return newLs.get();
    }

    public static <T> List<T> concat(List<T> ls, T t) {
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.add(t);
        return newLs;
    }

    public static <T> List<T> concat(T t, List<T> ls) {
        ArrayList<T> newLs = new ArrayList<T>(ls.size() + 1);
        newLs.add(t);
        newLs.addAll(ls);
        return newLs;
    }
}

