/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.config.DeclarativeNamedStyles;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.yaml.snakeyaml.Yaml;

public class YamlResourceLoader
implements ResourceLoader {
    private static final ObjectMapper mapper = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", ":");
    private final URI source;
    private final String yamlSource;

    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties) throws UncheckedIOException {
        this.source = source;
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = yamlInput.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            this.yamlSource = propertyPlaceholderHelper.replacePlaceholders(new String(buffer.toByteArray(), StandardCharsets.UTF_8), properties);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Collection<Map<String, Object>> loadResources(ResourceType resourceType) {
        ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
        Yaml yaml = new Yaml();
        for (Object resource : yaml.loadAll(this.yamlSource)) {
            Map resourceMap;
            if (!(resource instanceof Map) || !resourceType.equals((Object)ResourceType.fromSpec((String)(resourceMap = (Map)resource).get("type")))) continue;
            resources.add(resourceMap);
        }
        return resources;
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.loadResources(ResourceType.Recipe).stream().filter(r -> r.containsKey("name")).map(r -> {
            String name = (String)r.get("name");
            DeclarativeRecipe recipe = new DeclarativeRecipe(name, this.source);
            List recipeList = (List)r.get("recipeList");
            for (int i = 0; i < recipeList.size(); ++i) {
                Object next = recipeList.get(i);
                if (next instanceof String) {
                    recipe.doNext((String)next);
                    continue;
                }
                if (next instanceof Map) {
                    Map.Entry nameAndConfig = ((Map)next).entrySet().iterator().next();
                    try {
                        recipe.doNext((Recipe)mapper.convertValue(nameAndConfig.getValue(), Class.forName((String)nameAndConfig.getKey())));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                recipe.addValidation(Validated.invalid(name + ".recipeList[" + i + "] (in " + this.source + ")", next, "is an object type that isn't recognized as a recipe.", null));
            }
            return recipe;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.loadResources(ResourceType.Style).stream().filter(r -> r.containsKey("name")).map(s -> {
            ArrayList<Style> styles = new ArrayList<Style>();
            String name = (String)s.get("name");
            DeclarativeNamedStyles namedStyles = new DeclarativeNamedStyles(name, styles);
            List styleConfigs = (List)s.get("styleConfigs");
            if (styleConfigs != null) {
                for (Map styleConfig : styleConfigs) {
                    Map.Entry nameAndConfig = styleConfig.entrySet().iterator().next();
                    try {
                        styles.add((Style)Class.forName((String)nameAndConfig.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception e) {
                        namedStyles.addValidation(Validated.invalid(name + ".configure (in " + this.source + ")", nameAndConfig.getKey(), "is a style that cannot be constructed.", e));
                    }
                }
            }
            return namedStyles;
        }).collect(Collectors.toList());
    }

    private static enum ResourceType {
        Recipe("specs.openrewrite.org/v1beta/recipe"),
        Style("specs.openrewrite.org/v1beta/style");

        private final String spec;

        private ResourceType(String spec) {
            this.spec = spec;
        }

        public String getSpec() {
            return this.spec;
        }

        @Nullable
        public static ResourceType fromSpec(@Nullable String spec) {
            return Arrays.stream(ResourceType.values()).filter(type -> type.getSpec().equals(spec)).findAny().orElse(null);
        }
    }
}

