/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.openrewrite.Recipe;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.style.NamedStyles;

public class Environment {
    private final Collection<ResourceLoader> resourceLoaders;

    public Collection<Recipe> listRecipes() {
        List<Recipe> recipes = this.resourceLoaders.stream().flatMap(r -> r.listRecipes().stream()).collect(Collectors.toList());
        for (Recipe recipe : recipes) {
            if (!(recipe instanceof DeclarativeRecipe)) continue;
            ((DeclarativeRecipe)recipe).initialize(recipes);
        }
        return recipes;
    }

    public Recipe activateRecipes(String ... activeRecipes) {
        Recipe root = new Recipe();
        List<String> activeRecipeList = Arrays.asList(activeRecipes);
        for (Recipe recipe : this.listRecipes()) {
            if (!activeRecipeList.contains(recipe.getName())) continue;
            root.doNext(recipe);
        }
        return root;
    }

    public List<NamedStyles> listStyles() {
        return this.resourceLoaders.stream().flatMap(r -> r.listStyles().stream()).collect(Collectors.toList());
    }

    public List<NamedStyles> activateStyles(String ... activeStyles) {
        ArrayList<NamedStyles> activated = new ArrayList<NamedStyles>(activeStyles.length);
        List<NamedStyles> styles = this.listStyles();
        for (String activeStyle : activeStyles) {
            for (NamedStyles style : styles) {
                if (!style.getName().equals(activeStyle)) continue;
                activated.add(style);
            }
        }
        return activated;
    }

    public Environment(Collection<ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    public static Builder builder(Properties properties) {
        return new Builder(properties);
    }

    public static Builder builder() {
        return new Builder(new Properties());
    }

    public static class Builder {
        private final Properties properties;
        private final Collection<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();

        public Builder(Properties properties) {
            this.properties = properties;
        }

        public Builder scanClasspath(Iterable<Path> compileClasspath, String ... acceptPackages) {
            return this.load(new ClasspathScanningLoader(compileClasspath, this.properties, acceptPackages));
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                Builder builder;
                FileInputStream is = new FileInputStream(userHomeRewriteConfig);
                try {
                    builder = this.load(new YamlResourceLoader(is, userHomeRewriteConfig.toURI(), this.properties));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
                return builder;
            }
            return this;
        }

        public Builder load(ResourceLoader resourceLoader) {
            this.resourceLoaders.add(resourceLoader);
            return this;
        }

        public Environment build() {
            return new Environment(this.resourceLoaders);
        }
    }
}

