/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public abstract class TreeVisitor<T extends Tree, P> {
    private static final boolean IS_DEBUGGING = System.getProperty("org.openrewrite.debug") != null || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    protected boolean cursored = IS_DEBUGGING;
    private final ThreadLocal<Cursor> cursor = new ThreadLocal();
    private final ThreadLocal<List<TreeVisitor<T, P>>> afterVisit = new ThreadLocal();

    protected final void setCursoringOn() {
        this.cursored = true;
    }

    protected void setCursor(@Nullable Cursor cursor) {
        this.cursor.set(cursor);
    }

    protected void doAfterVisit(TreeVisitor<T, P> visitor) {
        this.afterVisit.get().add(visitor);
    }

    protected void doAfterVisit(Recipe visitor) {
        this.afterVisit.get().add(visitor.getVisitor());
    }

    protected List<TreeVisitor<T, P>> getAfterVisit() {
        return this.afterVisit.get();
    }

    public final Cursor getCursor() {
        if (this.cursor.get() == null) {
            throw new IllegalStateException("Cursoring is not enabled for this visitor. Call setCursoringOn() in the visitor's constructor to enable.");
        }
        return this.cursor.get();
    }

    @Nullable
    public T visitEach(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p, Cursor parent) {
        this.cursor.set(parent);
        return this.visit(tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p) {
        Tree t;
        if (tree == null) {
            return this.defaultValue(null, p);
        }
        boolean topLevel = false;
        if (this.afterVisit.get() == null) {
            topLevel = true;
            this.afterVisit.set(new ArrayList());
        }
        if (this.cursored) {
            this.cursor.set(new Cursor(this.cursor.get(), tree));
        }
        if ((t = this.visitEach(tree, p)) == null) {
            this.afterVisit.remove();
            return this.defaultValue(null, p);
        }
        t = t.accept(this, p);
        if (this.cursored) {
            this.cursor.set(this.cursor.get().getParent());
        }
        if (topLevel) {
            for (TreeVisitor<T, P> v : this.afterVisit.get()) {
                t = v.visit(t, p);
            }
            this.afterVisit.remove();
        }
        return (T)t;
    }

    @Nullable
    public T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    @Incubating(since="7.0.0")
    protected <T2 extends Tree> T2 visitAndCast(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Nullable
    @Incubating(since="7.0.0")
    protected <T2 extends T> T2 visitAndCast(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, p);
    }
}

