/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.style;

import java.beans.ConstructorProperties;
import java.util.Collection;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.Style;

public class NamedStyles
implements Marker {
    private final String name;
    private final Collection<Style> styles;

    @Nullable
    public static <S extends Style> S merge(Class<S> styleClass, Iterable<? extends NamedStyles> namedStyles) {
        Style merged = null;
        for (NamedStyles namedStyles2 : namedStyles) {
            for (Style style : namedStyles2.styles) {
                if (!styleClass.isInstance(style)) continue;
                if (merged == null) {
                    merged = style;
                    continue;
                }
                merged = merged.merge(style);
            }
        }
        return (S)merged;
    }

    public Validated validate() {
        return Validated.none();
    }

    @ConstructorProperties(value={"name", "styles"})
    public NamedStyles(String name, Collection<Style> styles) {
        this.name = name;
        this.styles = styles;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Style> getStyles() {
        return this.styles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedStyles)) {
            return false;
        }
        NamedStyles other = (NamedStyles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Collection<Style> this$styles = this.getStyles();
        Collection<Style> other$styles = other.getStyles();
        return !(this$styles == null ? other$styles != null : !((Object)this$styles).equals(other$styles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NamedStyles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Collection<Style> $styles = this.getStyles();
        result = result * 59 + ($styles == null ? 43 : ((Object)$styles).hashCode());
        return result;
    }

    public String toString() {
        return "NamedStyles(name=" + this.getName() + ", styles=" + this.getStyles() + ")";
    }
}

