/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.openrewrite.Cursor;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;

public abstract class TreeProcessor<T extends Tree, P>
implements TreeVisitor<T, P> {
    private static final boolean IS_DEBUGGING = System.getProperty("org.openrewrite.debug") != null || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private boolean cursored = IS_DEBUGGING;
    private final ThreadLocal<Cursor> cursor = new ThreadLocal();
    private final ThreadLocal<List<TreeProcessor<T, P>>> afterVisit = new ThreadLocal();

    protected final void setCursoringOn() {
        this.cursored = true;
    }

    protected void rebaseCursor(Tree t) {
        this.cursor.set(new Cursor(this.getCursor().getParent(), t));
    }

    protected void doAfterVisit(TreeProcessor<T, P> visitor) {
        this.afterVisit.get().add(visitor);
    }

    protected void doAfterVisit(Recipe visitor) {
        this.afterVisit.get().add(visitor.getProcessor().get());
    }

    protected List<TreeProcessor<T, P>> getAfterVisit() {
        return this.afterVisit.get();
    }

    public final Cursor getCursor() {
        if (this.cursor.get() == null) {
            throw new IllegalStateException("Cursoring is not enabled for this processor. Call setCursoringOn() in the processor's constructor to enable.");
        }
        return this.cursor.get();
    }

    @Nullable
    public T visitEach(T tree, P p) {
        return (T)this.defaultValue((Tree)tree, (Object)p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p, Cursor parent) {
        this.cursor.set(parent);
        return (T)this.visit(tree, (Object)p);
    }

    @Override
    @Nullable
    public T visit(@Nullable Tree tree, P p) {
        Object t;
        if (tree == null) {
            return (T)this.defaultValue((Tree)null, (Object)p);
        }
        boolean topLevel = false;
        if (this.afterVisit.get() == null) {
            topLevel = true;
            this.afterVisit.set(new ArrayList());
        }
        if (this.cursored) {
            this.cursor.set(new Cursor(this.cursor.get(), tree));
        }
        if ((t = this.visitEach(tree, p)) == null) {
            this.afterVisit.remove();
            return (T)this.defaultValue((Tree)null, (Object)p);
        }
        t = (Tree)t.accept(this, p);
        if (this.cursored) {
            this.cursor.set(this.cursor.get().getParent());
        }
        if (topLevel) {
            for (TreeProcessor<T, P> v : this.afterVisit.get()) {
                t = v.visit((Tree)t, (Object)p);
            }
            this.afterVisit.remove();
        }
        return (T)t;
    }

    @Override
    @Nullable
    public T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    protected <T2 extends Tree> T2 call(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Nullable
    protected <T2 extends T> T2 call(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, (Object)p);
    }

    @Nullable
    protected <T2 extends T> List<T2> call(@Nullable List<T2> trees, P p) {
        if (trees == null) {
            return null;
        }
        ArrayList<Object> mutatedTrees = new ArrayList<Object>(trees.size());
        boolean changed = false;
        for (Tree tree : trees) {
            Object mutated = this.visit(tree, (Object)p);
            if (mutated != tree || mutated == null) {
                changed = true;
            }
            if (mutated == null) continue;
            mutatedTrees.add(mutated);
        }
        return changed ? mutatedTrees : trees;
    }
}

