/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public interface Tree {
    public static UUID randomId() {
        return UUID.randomUUID();
    }

    public Markers getMarkers();

    public <T extends Tree> T withMarkers(Markers var1);

    default public <T extends Tree> T mark(Marker ... add) {
        Markers markers = this.getMarkers();
        for (Marker marker : add) {
            markers = markers.add(marker);
        }
        return this.withMarkers(markers);
    }

    @JsonIgnore
    @Nullable
    default public <S extends Style> S getStyle(Class<S> style) {
        return NamedStyles.merge(style, this.getMarkers().findAll(NamedStyles.class));
    }

    public UUID getId();

    @Nullable
    default public <R, P> R accept(TreeVisitor<R, P> v, P p) {
        return v.defaultValue(this, p);
    }

    public String print(TreePrinter<?> var1);

    default public String print() {
        return this.print(TreePrinter.identity());
    }

    default public String printTrimmed(TreePrinter<?> printer) {
        return StringUtils.trimIndent(this.print(printer).trim());
    }

    default public String printTrimmed() {
        return this.printTrimmed(TreePrinter.identity());
    }

    default public boolean isScope(@Nullable Tree tree) {
        return tree != null && tree.getId().equals(this.getId());
    }
}

