/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeProcessor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public class Recipe {
    public static final TreeProcessor<?, ExecutionContext> NOOP = new TreeProcessor<Tree, ExecutionContext>(){

        @Override
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            return tree;
        }
    };
    @Nullable
    private final String name;
    @Nullable
    private Recipe next;
    protected Supplier<TreeProcessor<?, ExecutionContext>> processor = () -> NOOP;

    public Recipe(@Nullable String name) {
        this.name = name;
    }

    public Recipe() {
        this(null);
    }

    public Recipe doNext(Recipe recipe) {
        Recipe tail = this;
        while (tail.next != null) {
            tail = tail.next;
        }
        tail.next = recipe;
        return this;
    }

    Supplier<TreeProcessor<?, ExecutionContext>> getProcessor() {
        return this.processor;
    }

    private List<SourceFile> visit(List<SourceFile> before, ExecutionContext execution) {
        List<SourceFile> after = before;
        if (this.validate().isValid()) {
            after = ListUtils.map(after, execution.getForkJoinPool(), s -> {
                try {
                    SourceFile afterFile = (SourceFile)this.processor.get().visit((Tree)s, (Object)execution);
                    if (afterFile != null && afterFile != s) {
                        afterFile = (SourceFile)afterFile.withMarkers(afterFile.getMarkers().compute(new RecipeThatMadeChanges(this.getName()), (r1, r2) -> {
                            ((RecipeThatMadeChanges)r1).names.addAll(((RecipeThatMadeChanges)r2).names);
                            return r1;
                        }));
                    }
                    return afterFile;
                }
                catch (Throwable t) {
                    if (execution.getOnError() != null) {
                        execution.getOnError().accept(t);
                    }
                    return s;
                }
            });
        }
        if (this.next != null) {
            after = this.next.visit(after, execution);
        }
        return after;
    }

    public final List<Result> run(List<SourceFile> before) {
        return this.run(before, ExecutionContext.builder().build());
    }

    public final List<Result> run(List<SourceFile> before, ExecutionContext context) {
        List<SourceFile> acc;
        List<SourceFile> after = acc = before;
        for (int i = 0; i < context.getMaxCycles() && ((after = this.visit(before, context)) != acc || context.isNeedAnotherCycle()); ++i) {
            acc = after;
            context.nextCycle();
        }
        if (after == before) {
            return Collections.emptyList();
        }
        Map sourceFileIdentities = before.stream().collect(Collectors.toMap(Tree::getId, Function.identity()));
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile s : after) {
            SourceFile original = (SourceFile)sourceFileIdentities.get(s.getId());
            if (original == s) continue;
            results.add(new Result(original, s, s.getMarkers().findFirst(RecipeThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change?")).names));
        }
        Set afterIds = after.stream().map(Tree::getId).collect(Collectors.toSet());
        for (SourceFile s : before) {
            if (afterIds.contains(s.getId())) continue;
            results.add(new Result(s, null, Collections.emptySet()));
        }
        return results;
    }

    public Validated validate() {
        return Validated.none();
    }

    public final Collection<Validated> validateAll() {
        return this.validateAll(new ArrayList<Validated>());
    }

    private Collection<Validated> validateAll(Collection<Validated> acc) {
        acc.add(this.validate());
        if (this.next != null) {
            this.validateAll(acc);
        }
        return acc;
    }

    public String getName() {
        return this.name == null ? this.getClass().getName() : this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    private static class RecipeThatMadeChanges
    implements Marker {
        private final Set<String> names = new HashSet<String>();

        private RecipeThatMadeChanges(String name) {
            this.names.add(name);
        }
    }
}

