/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Incubating;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@Incubating(since="2.0.0")
public interface Validated
extends Iterable<Validated> {
    public boolean isValid();

    default public boolean isInvalid() {
        return !this.isValid();
    }

    default public List<Invalid> failures() {
        return StreamSupport.stream(this.spliterator(), false).filter(Validated::isInvalid).map(v -> (Invalid)v).collect(Collectors.toList());
    }

    public static Secret validSecret(String property, String value) {
        return new Secret(property, value);
    }

    public static None none() {
        return new None();
    }

    public static Valid valid(String property, @Nullable Object value) {
        return new Valid(property, value);
    }

    public static <T> Validated test(String property, String message, @Nullable T value, Predicate<T> test) {
        return test.test(value) ? Validated.valid(property, value) : Validated.invalid(property, value, message.replace("{}", value == null ? "null" : value.toString()));
    }

    public static Validated required(String property, @Nullable Object value) {
        return value != null ? Validated.valid(property, value) : Validated.missing(property, value, "is required");
    }

    public static Validated notBlank(String property, @Nullable String value) {
        return Validated.test(property, "must not be blank", value, s -> value != null && !StringUtils.isBlank(value));
    }

    public static Missing missing(String property, @Nullable Object value, String message) {
        return new Missing(property, value, message);
    }

    public static Invalid invalid(String property, @Nullable Object value, String message) {
        return Validated.invalid(property, value, message, null);
    }

    public static Invalid invalid(String property, @Nullable Object value, String message, @Nullable Throwable exception) {
        return new Invalid(property, value, message, exception);
    }

    default public Validated and(Validated validated) {
        if (this instanceof None) {
            return validated;
        }
        return new Both(this, validated);
    }

    default public Validated or(Validated validated) {
        if (this instanceof None) {
            return validated;
        }
        return new Either(this, validated);
    }

    public <T> T getValue();

    public static class Both
    implements Validated {
        private final Validated left;
        private final Validated right;

        public Both(Validated left, Validated right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isValid() {
            return this.left.isValid() && this.right.isValid();
        }

        @Override
        public <T> T getValue() {
            return this.right.getValue();
        }

        @Override
        @NonNull
        public Iterator<Validated> iterator() {
            return Stream.concat(StreamSupport.stream(this.left.spliterator(), false), StreamSupport.stream(this.right.spliterator(), false)).iterator();
        }
    }

    public static class Either
    implements Validated {
        private final Validated left;
        private final Validated right;

        public Either(Validated left, Validated right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isValid() {
            return this.left.isValid() || this.right.isValid();
        }

        public Optional<Valid> findAny() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 4096), false).filter(Valid.class::isInstance).map(Valid.class::cast).findAny();
        }

        @Override
        public <T> T getValue() {
            return (T)this.findAny().map(v -> v.getValue()).orElseThrow(() -> new IllegalStateException("Value does not exist"));
        }

        @Override
        @NonNull
        public Iterator<Validated> iterator() {
            return Stream.concat(StreamSupport.stream(this.left.spliterator(), false), StreamSupport.stream(this.right.spliterator(), false)).iterator();
        }
    }

    public static class Missing
    extends Invalid {
        public Missing(String property, Object value, String message) {
            super(property, value, message, null);
        }
    }

    public static class Invalid
    implements Validated {
        private final String property;
        @Nullable
        private final Object value;
        private final String message;
        @Nullable
        private final Throwable exception;

        public Invalid(String property, @Nullable Object value, String message, @Nullable Throwable exception) {
            this.property = property;
            this.value = value;
            this.message = message;
            this.exception = exception;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        @NonNull
        public Iterator<Validated> iterator() {
            return Stream.of(this).iterator();
        }

        public String getMessage() {
            return this.message;
        }

        public String getProperty() {
            return this.property;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        @Nullable
        public Throwable getException() {
            return this.exception;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{property='" + this.property + '\'' + ", value='" + this.value + '\'' + ", message='" + this.message + '\'' + '}';
        }
    }

    public static class Valid
    implements Validated {
        protected final String property;
        private final Object value;

        public Valid(String property, Object value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NonNull
        public Iterator<Validated> iterator() {
            return Stream.of(this).iterator();
        }

        public String getProperty() {
            return this.property;
        }

        @Override
        public <T> T getValue() {
            return (T)this.value;
        }

        public String toString() {
            return "Valid{property='" + this.property + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static class Secret
    extends Valid {
        public Secret(String property, String value) {
            super(property, value);
        }

        @Override
        public String toString() {
            return "Secret{property='" + this.property + '\'' + '}';
        }
    }

    public static class None
    implements Validated {
        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NonNull
        public Iterator<Validated> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public <T> T getValue() {
            throw new IllegalStateException("Value does not exist");
        }
    }
}

