/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.AutoConfigure;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigureRefactorVisitorLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(AutoConfigureRefactorVisitorLoader.class);
    private final Iterable<Path> compileClasspath;
    private final String[] acceptVisitorPackages;

    public AutoConfigureRefactorVisitorLoader(Iterable<Path> compileClasspath, String ... acceptVisitorPackages) {
        this.compileClasspath = compileClasspath;
        this.acceptVisitorPackages = acceptVisitorPackages;
    }

    @Override
    public Collection<? extends RefactorVisitor<?>> loadVisitors() {
        ArrayList visitors = new ArrayList(this.loadVisitors(new ClassGraph()));
        if (this.compileClasspath.iterator().hasNext()) {
            URLClassLoader classpathLoader = new URLClassLoader((URL[])StreamSupport.stream(this.compileClasspath.spliterator(), false).map(cc -> {
                try {
                    return cc.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new), this.getClass().getClassLoader());
            visitors.addAll(this.loadVisitors(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classpathLoader})));
        }
        return visitors;
    }

    @NotNull
    private List<RefactorVisitor<?>> loadVisitors(ClassGraph classGraph) {
        if (this.acceptVisitorPackages != null && this.acceptVisitorPackages.length > 0) {
            classGraph = classGraph.acceptPackages(this.acceptVisitorPackages);
        }
        try (ScanResult scanResult = classGraph.enableMemoryMapping().enableAnnotationInfo().ignoreClassVisibility().scan();){
            List<RefactorVisitor<?>> list = scanResult.getClassesWithAnnotation(AutoConfigure.class.getName()).stream().map(classInfo -> {
                Class visitorClass = classInfo.loadClass();
                try {
                    Constructor constructor = visitorClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return (RefactorVisitor)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)visitorClass.getName(), (Object)e);
                    return null;
                }
            }).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public Map<String, Collection<Style>> loadStyles() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<RecipeConfiguration> loadRecipes() {
        return Collections.emptyList();
    }
}

