/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;

public class CompositeRefactorVisitor
implements RefactorVisitor<Tree> {
    private final List<RefactorVisitor<? extends Tree>> delegates = new ArrayList<RefactorVisitor<? extends Tree>>();
    private final List<RefactorVisitor<? extends Tree>> andThen = new ArrayList<RefactorVisitor<? extends Tree>>();

    public void addVisitor(RefactorVisitor<? extends Tree> visitor) {
        this.delegates.add(visitor);
    }

    @Override
    public Validated validate() {
        return this.delegates.stream().map(SourceVisitor::validate).reduce(Validated.none(), (validation, acc) -> acc.and((Validated)validation));
    }

    @Override
    public Tree visit(Tree tree) {
        return tree;
    }

    @Override
    public Collection<SourceFile> generate() {
        return this.delegates.stream().flatMap(d -> d.generate().stream()).collect(Collectors.toList());
    }

    public void extendsFrom(CompositeRefactorVisitor delegate) {
        this.delegates.add(0, delegate);
    }

    @Override
    public Tree defaultTo(Tree t) {
        return this.delegates.stream().map(d -> d instanceof CompositeRefactorVisitor ? ((CompositeRefactorVisitor)d).defaultTo(t) : d.defaultTo(t)).filter(Objects::nonNull).findAny().orElse(null);
    }

    @Override
    public List<RefactorVisitor<? extends Tree>> andThen() {
        return this.andThen;
    }

    @Override
    public void next() {
        this.andThen.clear();
        this.delegates.forEach(RefactorVisitor::next);
        this.andThen.addAll(this.delegates);
    }
}

