/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import kotlin.text.Charsets;
import org.openrewrite.CompositeRefactorVisitor;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.StyleConfiguration;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.Nullable;
import org.yaml.snakeyaml.Yaml;

public class YamlResourceLoader
implements ResourceLoader {
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", ":");
    private final Map<String, RecipeConfiguration> recipes = new HashMap<String, RecipeConfiguration>();
    private final Collection<CompositeRefactorVisitor> visitors = new ArrayList<CompositeRefactorVisitor>();
    private final Map<CompositeRefactorVisitor, String> visitorExtensions = new HashMap<CompositeRefactorVisitor, String>();
    private final Map<String, Collection<Style>> styles = new HashMap<String, Collection<Style>>();
    private final URI source;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties) throws UncheckedIOException {
        this.source = source;
        try {
            try {
                int nRead;
                Yaml yaml = new Yaml();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = yamlInput.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                String yamlSource = new String(buffer.toByteArray(), Charsets.UTF_8);
                yamlSource = propertyPlaceholderHelper.replacePlaceholders(yamlSource, properties);
                for (Object t : yaml.loadAll(yamlSource)) {
                    if (!(t instanceof Map)) continue;
                    Map resourceMap = (Map)t;
                    String type = resourceMap.getOrDefault("type", "missing").toString();
                    Validated validated = Validated.required("type", type).and(Validated.test("type", "must be one of the following resource types: " + Arrays.stream(ResourceType.values()).map(ResourceType::getSpec).collect(Collectors.joining(", ")), type, type2 -> ResourceType.fromSpec(type2) != null));
                    if (validated.isInvalid()) {
                        throw new ValidationException(validated, source);
                    }
                    switch (ResourceType.fromSpec(type)) {
                        case Visitor: {
                            this.mapVisitor(resourceMap);
                            break;
                        }
                        case Recipe: {
                            this.mapRecipe(resourceMap);
                            break;
                        }
                        case Style: {
                            this.mapStyle(resourceMap);
                        }
                    }
                }
                for (Map.Entry entry : this.visitorExtensions.entrySet()) {
                    this.visitors.stream().filter(v -> v.getName().equals(extendingVisitor.getValue())).findAny().ifPresent(v -> ((CompositeRefactorVisitor)extendingVisitor.getKey()).extendsFrom((CompositeRefactorVisitor)v));
                }
            }
            finally {
                yamlInput.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void mapVisitor(Map<String, Object> visitorMap) {
        Validated validation = Validated.required("name", visitorMap.get("name")).and(Validated.required("visitors", visitorMap.get("visitors"))).and(Validated.test("visitors", "must be a list", visitorMap.get("visitors"), visitors -> visitors instanceof List));
        if (validation.isInvalid()) {
            throw new ValidationException(validation, this.source);
        }
        ArrayList<RefactorVisitor<? extends Tree>> subVisitors = new ArrayList<RefactorVisitor<? extends Tree>>();
        for (Object subVisitorNameAndConfig : (List)visitorMap.get("visitors")) {
            try {
                if (subVisitorNameAndConfig instanceof String) {
                    subVisitors.add((RefactorVisitor)this.visitorClass((String)subVisitorNameAndConfig).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                if (!(subVisitorNameAndConfig instanceof Map)) continue;
                for (Map.Entry subVisitorEntry : ((Map)subVisitorNameAndConfig).entrySet()) {
                    RefactorVisitor subVisitor = (RefactorVisitor)this.visitorClass((String)subVisitorEntry.getKey()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    propertyConverter.updateValue((Object)subVisitor, subVisitorEntry.getValue());
                    subVisitors.add(subVisitor);
                }
            }
            catch (Exception e) {
                throw new ValidationException(Validated.invalid("visitor", subVisitorNameAndConfig, "must be constructable", e), this.source);
            }
        }
        ResourceLoadedVisitor visitor = new ResourceLoadedVisitor(visitorMap.get("name").toString(), subVisitors);
        if (visitorMap.containsKey("extends")) {
            this.visitorExtensions.put(visitor, visitorMap.get("extends").toString());
        }
        this.visitors.add(visitor);
    }

    private Class<?> visitorClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ignored) {
            return Class.forName("org.openrewrite." + name);
        }
    }

    private void mapRecipe(Map<String, Object> recipeMap) {
        RecipeConfiguration recipe = new RecipeConfiguration();
        try {
            propertyConverter.updateValue((Object)recipe, recipeMap);
        }
        catch (JsonMappingException e) {
            if (e.getCause() != null && e.getCause() instanceof ValidationException) {
                throw (ValidationException)e.getCause();
            }
            throw new ValidationException(Validated.invalid("recipe", recipeMap, "must be a valid recipe configuration", e), this.source);
        }
        Validated validated = Validated.required("name", recipe.getName()).and(Validated.test("name", "there is already another recipe with that name", recipe.getName(), it -> !this.recipes.containsKey(it)));
        if (validated.isInvalid()) {
            throw new ValidationException(validated, this.source);
        }
        this.recipes.put(recipe.getName(), recipe);
    }

    private void mapStyle(Map<String, Object> styleMap) {
        StyleConfiguration style = new StyleConfiguration();
        try {
            propertyConverter.updateValue((Object)style, styleMap);
        }
        catch (JsonMappingException e) {
            if (e.getCause() != null && e.getCause() instanceof ValidationException) {
                throw (ValidationException)e.getCause();
            }
            throw new ValidationException(Validated.invalid("styles", styleMap, "must be a valid style configuration", e), this.source);
        }
        Validated validated = Validated.required("name", style.getName()).and(Validated.test("name", "there is already another style configuration with that name", style.getName(), it -> !this.styles.containsKey(it)));
        if (validated.isInvalid()) {
            throw new ValidationException(validated, this.source);
        }
        this.styles.put(style.getName(), style.getStyles());
    }

    @Override
    public Collection<RecipeConfiguration> loadRecipes() {
        return this.recipes.values();
    }

    @Override
    public Collection<? extends RefactorVisitor<?>> loadVisitors() {
        return this.visitors;
    }

    @Override
    public Map<String, Collection<Style>> loadStyles() {
        return this.styles;
    }

    private static class ResourceLoadedVisitor
    extends CompositeRefactorVisitor {
        private final String name;

        public ResourceLoadedVisitor(String name, List<RefactorVisitor<? extends Tree>> delegates) {
            this.name = name;
            delegates.forEach(this::addVisitor);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Iterable<Tag> getTags() {
            return Tags.of((String)"name", (String)this.name);
        }
    }

    private static enum ResourceType {
        Visitor("specs.openrewrite.org/v1beta/visitor"),
        Recipe("specs.openrewrite.org/v1beta/recipe"),
        Style("specs.openrewrite.org/v1beta/style");

        private final String spec;

        private ResourceType(String spec) {
            this.spec = spec;
        }

        public String getSpec() {
            return this.spec;
        }

        @Nullable
        public static ResourceType fromSpec(String spec) {
            return Arrays.stream(ResourceType.values()).filter(type -> type.getSpec().equals(spec)).findAny().orElse(null);
        }
    }
}

