/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Recipe;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.ValidationException;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RecipeConfiguration.class);
    private static final ObjectMapper propertyConverter = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Map<Class<? extends SourceVisitor>, Map<String, Object>> propertiesByVisitor = new IdentityHashMap<Class<? extends SourceVisitor>, Map<String, Object>>();
    private String name = null;
    private Set<Pattern> include = Collections.emptySet();
    private Set<Pattern> exclude = Collections.emptySet();
    private Map<String, Object> configure = new HashMap<String, Object>();

    public String getName() {
        return this.name;
    }

    public Set<Pattern> getInclude() {
        return this.include;
    }

    public Set<Pattern> getExclude() {
        return this.exclude;
    }

    public void setName(String name) {
        Validated validated = Validated.notBlank("name", name).and(Validated.test("name", "contains characters other than letters, numbers, '-', and '_'", name, it -> it.matches("[\\p{L}0-9_.-]+"))).and(Validated.test("name", "that is not fully qualified. Fully qualify the name '" + name + "' with a package, like 'com.myproject." + name + "'", name, it -> it.matches("(([\\p{L}0-9_-]+)\\.)+([\\p{L}0-9_-]+)")));
        if (validated.isInvalid()) {
            throw new ValidationException(validated);
        }
        this.name = name;
    }

    public void setInclude(Set<String> include) {
        this.include = this.toPatternSet(include);
    }

    public void setExclude(Set<String> exclude) {
        this.exclude = this.toPatternSet(exclude);
    }

    public void setConfigure(Map<String, Object> configure) {
        this.configure = configure;
    }

    private Set<Pattern> toPatternSet(Set<String> set) {
        return set.stream().map(i -> i.replace(".", "\\.").replace("*", "[^.]+")).map(Pattern::compile).collect(Collectors.toSet());
    }

    public Recipe build() {
        final ArrayDeque<RecipeConfiguration> inOrderConfigurations = new ArrayDeque<RecipeConfiguration>();
        LinkedList<RecipeConfiguration> configs = new LinkedList<RecipeConfiguration>();
        configs.add(this);
        while (!configs.isEmpty()) {
            RecipeConfiguration config = (RecipeConfiguration)configs.poll();
            inOrderConfigurations.add(config);
        }
        Validated validated = Validated.required("name", this.name);
        if (validated.isInvalid()) {
            throw new ValidationException(validated);
        }
        return new Recipe(){

            @Override
            public String getName() {
                return RecipeConfiguration.this.name;
            }

            @Override
            public Recipe.FilterReply accept(RefactorVisitor<?> visitor) {
                return inOrderConfigurations.stream().reduce(Recipe.FilterReply.NEUTRAL, (reply, config) -> reply.equals((Object)Recipe.FilterReply.NEUTRAL) ? ((RecipeConfiguration)config).accept(visitor) : reply, (r1, r2) -> r1.equals((Object)Recipe.FilterReply.NEUTRAL) ? r2 : r1);
            }

            @Override
            public <T extends Tree, R extends RefactorVisitor<T>> R configure(R visitor) {
                Iterator configs = inOrderConfigurations.descendingIterator();
                while (configs.hasNext()) {
                    ((RecipeConfiguration)configs.next()).configure(visitor);
                }
                return visitor;
            }

            @Override
            public Set<Pattern> getInclude() {
                return RecipeConfiguration.this.include;
            }

            @Override
            public Set<Pattern> getExclude() {
                return RecipeConfiguration.this.exclude;
            }
        };
    }

    private void configure(SourceVisitor<?> visitor) {
        try {
            propertyConverter.updateValue(visitor, this.propertyMap(visitor));
        }
        catch (JsonMappingException e) {
            logger.warn("Unable to configure {}", (Object)visitor.getClass().getName(), (Object)e);
        }
    }

    protected Map<String, Object> propertyMap(SourceVisitor<?> visitor) {
        return this.propertiesByVisitor.computeIfAbsent(visitor.getClass(), clazz -> this.propertyMap(clazz.getName(), this.configure));
    }

    private Map<String, Object> propertyMap(String partialName, @Nullable Object config) {
        if (!(config instanceof Map)) {
            return Collections.emptyMap();
        }
        Map configMap = (Map)config;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int nextDot = partialName.indexOf(46);
        while (nextDot != -1) {
            String subpackage = partialName.substring(0, nextDot);
            String remaining = partialName.substring(nextDot + 1);
            for (Map.Entry configEntry : configMap.entrySet()) {
                if (!Pattern.compile(((String)configEntry.getKey()).replace("*", ".+")).matcher(subpackage).matches()) continue;
                properties.putAll(this.propertyMap(remaining, configEntry.getValue()));
            }
            nextDot = partialName.indexOf(46, nextDot + 1);
        }
        block2: for (Map.Entry configEntry : configMap.entrySet()) {
            Matcher matcher;
            HashMap value;
            String keyPart = (String)configEntry.getKey();
            if (configEntry.getValue() instanceof Map) {
                value = (HashMap)configEntry.getValue();
            } else {
                value = new HashMap();
                value.put(keyPart.substring(keyPart.lastIndexOf(46) + 1), configEntry.getValue());
                keyPart = keyPart.substring(0, Math.max(0, keyPart.lastIndexOf(46)));
            }
            do {
                if ((matcher = Pattern.compile("^" + keyPart.replace("*", ".+")).matcher(partialName)).find()) {
                    properties.putAll(value);
                    continue block2;
                }
                if (!matcher.hitEnd()) continue;
                HashMap value2 = new HashMap();
                value2.put(keyPart.substring(keyPart.lastIndexOf(46) + 1), value);
                value = value2;
                keyPart = keyPart.substring(0, keyPart.lastIndexOf(46));
            } while (matcher.hitEnd());
        }
        return properties;
    }

    private Recipe.FilterReply accept(SourceVisitor<?> visitor) {
        if (visitor.validate().isInvalid() || this.exclude.stream().anyMatch(i -> i.matcher(visitor.getName()).matches())) {
            return Recipe.FilterReply.DENY;
        }
        if (this.include.stream().anyMatch(i -> i.matcher(visitor.getName()).matches())) {
            return Recipe.FilterReply.ACCEPT;
        }
        return Recipe.FilterReply.NEUTRAL;
    }
}

