/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.Metadata;
import org.openrewrite.Style;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public interface SourceFile
extends Tree {
    public URI getSourcePath();

    public Collection<Metadata> getMetadata();

    @JsonIgnore
    default public <S extends SourceFile> S setMetadata(Metadata metadata) {
        ArrayList<Metadata> updatedMetadata = new ArrayList<Metadata>(this.getMetadata().size());
        boolean updated = false;
        for (Metadata metadatum : this.getMetadata()) {
            if (metadatum.getClass().equals(metadata.getClass())) {
                updatedMetadata.add(metadata);
                updated = true;
                continue;
            }
            updatedMetadata.add(metadatum);
        }
        if (!updated) {
            updatedMetadata.add(metadata);
        }
        return (S)this.withMetadata(updatedMetadata);
    }

    public SourceFile withMetadata(Collection<Metadata> var1);

    @Nullable
    default public <M extends Metadata> M getMetadata(Class<M> metadataType) {
        for (Metadata metadata : this.getMetadata()) {
            if (!metadataType.isInstance(metadata)) continue;
            return (M)metadata;
        }
        return null;
    }

    default public Collection<? extends Style> getStyles() {
        return Collections.emptyList();
    }

    @Nullable
    default public <S extends Style> S getStyle(Class<S> styleType) {
        for (Style style : this.getStyles()) {
            if (!styleType.isInstance(style)) continue;
            return (S)style;
        }
        return null;
    }

    @JsonProperty(value="@c")
    default public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }
}

