/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

public class Change {
    @Nullable
    private final SourceFile original;
    @Nullable
    private final SourceFile fixed;
    private final Set<String> visitorsThatMadeChanges;

    public Change(@Nullable SourceFile original, @Nullable SourceFile fixed, Set<String> visitorsThatMadeChanges) {
        this.original = original;
        this.fixed = fixed;
        this.visitorsThatMadeChanges = visitorsThatMadeChanges;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        Path sourcePath = this.fixed instanceof SourceFile ? Paths.get(this.fixed.getSourcePath()) : (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + this.fixed.getId());
        return new InMemoryDiffEntry(sourcePath, relativeTo, this.original == null ? "" : this.original.print(), this.fixed.print(), this.visitorsThatMadeChanges).getDiff();
    }

    public Class<? extends Tree> getTreeType() {
        return this.original == null ? (this.fixed == null ? null : this.fixed.getClass()) : this.original.getClass();
    }

    public SourceFile getOriginal() {
        return this.original;
    }

    public SourceFile getFixed() {
        return this.fixed;
    }

    public Set<String> getVisitorsThatMadeChanges() {
        return this.visitorsThatMadeChanges;
    }

    static class InMemoryDiffEntry
    extends DiffEntry {
        InMemoryRepository repo;
        Set<String> rulesThatMadeChanges;

        InMemoryDiffEntry(Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<String> rulesThatMadeChanges) {
            this.changeType = DiffEntry.ChangeType.MODIFY;
            this.rulesThatMadeChanges = rulesThatMadeChanges;
            Path relativePath = relativeTo == null ? filePath : relativeTo.relativize(filePath);
            this.oldPath = relativePath.toString();
            this.newPath = relativePath.toString();
            try {
                this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
                ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();
                this.oldId = inserter.insert(3, oldSource.getBytes()).abbreviate(40);
                this.newId = inserter.insert(3, newSource.getBytes()).abbreviate(40);
                inserter.flush();
                this.oldMode = FileMode.REGULAR_FILE;
                this.newMode = FileMode.REGULAR_FILE;
                this.repo.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        String getDiff() {
            if (this.oldId.equals((Object)this.newId)) {
                return "";
            }
            ByteArrayOutputStream patch = new ByteArrayOutputStream();
            DiffFormatter formatter = new DiffFormatter((OutputStream)patch);
            formatter.setRepository((Repository)this.repo);
            try {
                formatter.format((DiffEntry)this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String diff = new String(patch.toByteArray());
            AtomicBoolean addedComment = new AtomicBoolean(false);
            return Arrays.stream(diff.split("\n")).map(l -> {
                if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                    addedComment.set(true);
                    return l + this.rulesThatMadeChanges.stream().sorted().collect(Collectors.joining(", ", " ", ""));
                }
                return l;
            }).collect(Collectors.joining("\n")) + "\n";
        }
    }
}

