/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Change;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class Refactor {
    private static final Logger logger = LoggerFactory.getLogger(Refactor.class);
    private MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final boolean eagerlyThrow;
    private final Collection<RefactorVisitor<? extends Tree>> visitors = new ArrayList<RefactorVisitor<? extends Tree>>();

    public Refactor() {
        this(false);
    }

    public Refactor(boolean eagerlyThrow) {
        this.eagerlyThrow = eagerlyThrow;
    }

    @SafeVarargs
    public final Refactor visit(RefactorVisitor<? extends Tree> ... visitors) {
        Collections.addAll(this.visitors, visitors);
        return this;
    }

    public final Refactor visit(Iterable<RefactorVisitor<? extends Tree>> visitors) {
        visitors.forEach(this.visitors::add);
        return this;
    }

    @Nullable
    public <S extends SourceFile> S fixed(S tree) {
        return (S)this.fix(Collections.singletonList(tree)).iterator().next().getFixed();
    }

    public Collection<Change> fix(Iterable<? extends SourceFile> sources) {
        return this.fix(sources, 3);
    }

    public Collection<Change> fix(Iterable<? extends SourceFile> sources, int maxCycles) {
        Timer.Sample sample = Timer.start();
        HashMap<SourceFile, Change> changesByTree = new HashMap<SourceFile, Change>();
        ArrayList<Object> accumulatedSources = new ArrayList<Object>();
        sources.forEach(accumulatedSources::add);
        for (int i = 0; i < maxCycles; ++i) {
            int visitorsThatMadeChangesThisCycle = 0;
            for (int j = 0; j < accumulatedSources.size(); ++j) {
                SourceFile originalSource = (SourceFile)accumulatedSources.get(j);
                if (originalSource == null) continue;
                SourceFile acc = originalSource;
                for (RefactorVisitor<? extends Tree> visitor : this.visitors) {
                    try {
                        SourceFile before;
                        visitor.next();
                        if (!visitor.isIdempotent() && i > 0 || (before = acc) == (acc = (SourceFile)this.transformPipeline(acc, visitor))) continue;
                        changesByTree.compute(acc, (acc2, prevChange) -> prevChange == null ? new Change(originalSource, (SourceFile)acc2, Collections.singleton(visitor.getName())) : new Change(originalSource, (SourceFile)acc2, Stream.concat(prevChange.getVisitorsThatMadeChanges().stream(), Stream.of(visitor.getName())).collect(Collectors.toSet())));
                        ++visitorsThatMadeChangesThisCycle;
                    }
                    catch (Throwable t) {
                        logger.error("refactor visitor failed", t);
                        Counter.builder((String)"rewrite.visitor.errors").baseUnit("errors").description("Visitors that threw exceptions").tag("visitor", visitor.getName()).tag("tree.type", originalSource.getClass().getName()).tag("exception", t.getClass().getSimpleName()).register(this.meterRegistry).increment();
                        if (!this.eagerlyThrow) continue;
                        throw t;
                    }
                }
                for (RefactorVisitor<? extends Tree> visitor : this.visitors) {
                    List generatedSources = visitor.generate().stream().collect(Collectors.toList());
                    if (generatedSources.size() <= 0) continue;
                    accumulatedSources.addAll(generatedSources);
                    visitorsThatMadeChangesThisCycle += generatedSources.size();
                    for (SourceFile generatedSource : generatedSources) {
                        HashSet<String> visitorSet = new HashSet<String>();
                        visitorSet.add(visitor.getName());
                        changesByTree.put(generatedSource, new Change(null, generatedSource, visitorSet));
                    }
                }
                accumulatedSources.set(j, acc);
                for (RefactorVisitor<? extends Tree> visitor : this.visitors) {
                    visitor.nextCycle();
                }
            }
            if (visitorsThatMadeChangesThisCycle == 0 && i > 0) break;
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.plan").description("The time it takes to execute a refactoring plan consisting of potentially more than one visitor over more than one cycle").tag("outcome", changesByTree.isEmpty() ? "unchanged" : "changed").register(this.meterRegistry));
        for (Change change : changesByTree.values()) {
            for (String ruleThatMadeChange : change.getVisitorsThatMadeChanges()) {
                Counter.builder((String)"rewrite.refactor.plan.changes").description("The number of changes requested by a visitor").tag("visitor", ruleThatMadeChange).tag("tree.type", change.getTreeType() == null ? "unknown" : change.getTreeType().getName()).register(this.meterRegistry).increment();
            }
        }
        return changesByTree.values();
    }

    private Tree transformPipeline(Tree acc, RefactorVisitor<? extends Tree> visitor) {
        Timer.Sample sample = Timer.start();
        acc = (Tree)visitor.visit(acc);
        for (RefactorVisitor<? extends Tree> vis : visitor.andThen()) {
            acc = this.transformPipeline(acc, vis);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.visit").description("The time it takes to visit a single AST with a particular refactoring visitor and its pipeline").tag("visitor", visitor.getName()).tags(visitor.getTags()).tag("tree.type", acc.getClass().getSimpleName()).register(this.meterRegistry));
        return acc;
    }

    public Refactor setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public Collection<RefactorVisitor<? extends Tree>> getVisitors() {
        return this.visitors;
    }
}

