/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;

public class ClasspathResourceLoader
implements ResourceLoader {
    private final Collection<YamlResourceLoader> yamlResourceLoaders = new ArrayList<YamlResourceLoader>();

    public ClasspathResourceLoader(Iterable<Path> compileClasspath, Properties properties) {
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}).enableMemoryMapping().scan();){
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> this.yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties)));
        }
        if (compileClasspath.iterator().hasNext()) {
            scanResult = new ClassGraph().overrideClasspath(compileClasspath).acceptPaths(new String[]{"META-INF/rewrite"}).enableMemoryMapping().scan();
            try {
                scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> this.yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties)));
            }
            finally {
                if (scanResult != null) {
                    scanResult.close();
                }
            }
        }
    }

    @Override
    public Collection<RecipeConfiguration> loadRecipes() {
        return this.yamlResourceLoaders.stream().flatMap(loader -> loader.loadRecipes().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<? extends RefactorVisitor<?>> loadVisitors() {
        return this.yamlResourceLoaders.stream().flatMap(loader -> loader.loadVisitors().stream()).collect(Collectors.toList());
    }

    @Override
    public Map<String, Collection<Style>> loadStyles() {
        HashMap<String, Collection<Style>> styles = new HashMap<String, Collection<Style>>();
        this.yamlResourceLoaders.forEach(loader -> styles.putAll(loader.loadStyles()));
        return styles;
    }
}

