/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Style;
import org.openrewrite.config.RecipeConfiguration;
import org.openrewrite.config.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigureRefactorVisitorLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(AutoConfigureRefactorVisitorLoader.class);
    private final String[] acceptVisitorPackages;

    public AutoConfigureRefactorVisitorLoader(String ... acceptVisitorPackages) {
        this.acceptVisitorPackages = acceptVisitorPackages;
    }

    @Override
    public Collection<? extends RefactorVisitor<?>> loadVisitors() {
        try (ScanResult scanResult = new ClassGraph().acceptPackages(this.acceptVisitorPackages).enableMemoryMapping().enableMethodInfo().enableAnnotationInfo().ignoreClassVisibility().ignoreMethodVisibility().scan();){
            Collection collection = scanResult.getClassesWithAnnotation(AutoConfigure.class.getName()).stream().map(classInfo -> {
                Class visitorClass = classInfo.loadClass();
                try {
                    Constructor constructor = visitorClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return (RefactorVisitor)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)visitorClass.getName(), (Object)e);
                    return null;
                }
            }).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public Map<String, Collection<Style>> loadStyles() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<RecipeConfiguration> loadRecipes() {
        return Collections.emptyList();
    }
}

