/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Optional;
import java.util.UUID;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public interface Tree {
    public static UUID randomId() {
        return UUID.randomUUID();
    }

    public Formatting getFormatting();

    public UUID getId();

    public <T extends Tree> T withFormatting(Formatting var1);

    @JsonIgnore
    default public String getPrefix() {
        return this.getFormatting().getPrefix();
    }

    default public <T extends Tree> T withPrefix(String prefix) {
        return this.withFormatting(this.getFormatting().withPrefix(prefix));
    }

    @JsonIgnore
    default public String getSuffix() {
        return this.getFormatting().getSuffix();
    }

    default public <T extends Tree> T withSuffix(String suffix) {
        return this.withFormatting(this.getFormatting().withSuffix(suffix));
    }

    default public <R> R accept(SourceVisitor<R> v) {
        return v.defaultTo(null);
    }

    default public String printTrimmed() {
        return StringUtils.trimIndent(this.print().trim());
    }

    public String print();

    default public <T extends Tree> Optional<T> whenType(Class<T> treeType) {
        return treeType.isAssignableFrom(this.getClass()) ? Optional.of(this) : Optional.empty();
    }

    default public boolean isScope(@Nullable Tree tree) {
        return tree != null && tree.getId().equals(this.getId());
    }
}

