/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.net.URI;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Validated;

@Incubating(since="2.0.0")
public class ValidationException
extends RuntimeException {
    private final Validated validation;
    private URI source = null;

    public URI getSource() {
        return this.source;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public ValidationException(Validated validation) {
        this(validation, null);
    }

    public ValidationException(ValidationException other, URI source) {
        this(other.validation, source);
        this.setStackTrace(other.getStackTrace());
    }

    public ValidationException(Validated validation, URI source) {
        super(validation.failures().stream().map(invalid -> invalid.getProperty() + " was '" + (invalid.getValue() == null ? "null" : invalid.getValue()) + "' but it " + invalid.getMessage()).collect(Collectors.joining("\n", validation.failures().size() > 1 ? "Multiple validation failures:\n" : "", "")));
        this.validation = validation;
        this.source = source;
    }

    public Validated getValidation() {
        return this.validation;
    }

    @Override
    public String getMessage() {
        if (this.source != null) {
            return "Problem parsing rewrite configuration from: " + this.source + " \n" + super.getMessage();
        }
        return super.getMessage();
    }
}

