/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import org.openrewrite.Validated;
import org.openrewrite.semver.VersionComparator;

public class LatestRelease
implements VersionComparator {
    public static final LatestRelease INSTANCE = (LatestRelease)LatestRelease.build("latest.release").getValue();

    @Override
    public boolean isValid(String version) {
        return VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(version)).matches();
    }

    protected static String normalizeVersion(String version) {
        if (version.endsWith(".RELEASE")) {
            return version.substring(0, version.length() - ".RELEASE".length());
        }
        return version;
    }

    @Override
    public int compare(String v1, String v2) {
        Matcher v1Gav = VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(v1));
        Matcher v2Gav = VersionComparator.RELEASE_PATTERN.matcher(LatestRelease.normalizeVersion(v2));
        v1Gav.matches();
        v2Gav.matches();
        for (int i = 1; i <= 3; ++i) {
            String v1Part = v1Gav.group(i);
            String v2Part = v2Gav.group(i);
            if (v1Part == null) {
                return v2Part == null ? 0 : -11;
            }
            if (v2Part == null) {
                return 1;
            }
            int diff = Integer.parseInt(v1Part) - Integer.parseInt(v2Part);
            if (diff == 0) continue;
            return diff;
        }
        return v1.compareTo(v2);
    }

    public static Validated build(String pattern) {
        return pattern.equals("latest.release") ? Validated.valid("latestRelease", new LatestRelease()) : Validated.invalid("latestRelease", pattern, "not a hyphen range");
    }
}

