/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Validated;
import org.openrewrite.semver.LatestRelease;

public class TildeRange
extends LatestRelease {
    private static final Pattern TILDE_RANGE_PATTERN = Pattern.compile("~(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?");
    private final String upperExclusive;
    private final String lower;

    private TildeRange(String lower, String upperExclusive) {
        this.lower = lower;
        this.upperExclusive = upperExclusive;
    }

    @Override
    public boolean isValid(String version) {
        return super.isValid(version) && super.compare(version, this.upperExclusive) < 0 && super.compare(version, this.lower) >= 0;
    }

    public static Validated build(String pattern) {
        String upper;
        String lower;
        Matcher matcher = TILDE_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("tildeRange", pattern, "not a tilde range");
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        String patch = matcher.group(3);
        if (minor == null) {
            lower = major + ".0.0";
            upper = Integer.parseInt(major) + 1 + ".0.0";
        } else if (patch == null) {
            lower = major + "." + minor + ".0";
            upper = major + "." + (Integer.parseInt(minor) + 1) + ".0";
        } else {
            lower = major + "." + minor + "." + patch;
            upper = major + "." + (Integer.parseInt(minor) + 1) + ".0";
        }
        return Validated.valid("tildeRange", new TildeRange(lower, upper));
    }
}

