/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import org.openrewrite.Refactor;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;

public class CompositeRefactorVisitor
extends SourceVisitor<Tree> {
    private String name;
    private final List<SourceVisitor<? extends Tree>> delegates;

    public CompositeRefactorVisitor(String name, List<SourceVisitor<? extends Tree>> delegates) {
        this.name = name;
        this.delegates = delegates;
        for (SourceVisitor<? extends Tree> delegate : delegates) {
            this.andThen(delegate);
        }
    }

    @Override
    public Iterable<Tag> getTags() {
        return Tags.of((String)"name", (String)this.name);
    }

    CompositeRefactorVisitor setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getVisitorType() {
        return this.delegates.stream().findAny().map(Object::getClass).orElse(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Tree visitTree(Tree tree) {
        if (tree instanceof SourceFile) {
            Refactor<Tree> refactor = new Refactor<Tree>(tree);
            return refactor.visit(this.delegates).fix().getFixed();
        }
        return (Tree)super.visitTree(tree);
    }

    @Override
    public Tree defaultTo(Tree t) {
        return this.delegates.stream().findAny().map(v -> (Tree)v.defaultTo(t)).orElse(null);
    }
}

