/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import org.openrewrite.Refactor;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;

public class CompositeRefactorVisitor<T extends Tree>
extends SourceVisitor<T> {
    private String name;
    private final List<SourceVisitor<T>> delegates;

    public CompositeRefactorVisitor(String name, List<SourceVisitor<T>> delegates) {
        this.name = name;
        this.delegates = delegates;
        delegates.forEach(this::andThen);
    }

    @Override
    public Iterable<Tag> getTags() {
        return Tags.of((String)"name", (String)this.name);
    }

    CompositeRefactorVisitor<T> setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getVisitorType() {
        return this.delegates.stream().findAny().map(Object::getClass).orElse(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T visitTree(Tree tree) {
        Tree t = tree;
        if (tree instanceof SourceFile) {
            Refactor<SourceFile, T> refactor = new Refactor<SourceFile, T>((SourceFile)t);
            return (T)refactor.visit(this.delegates).fix().getFixed();
        }
        return (T)((Tree)super.visitTree(tree));
    }

    @Override
    public T defaultTo(Tree t) {
        return (T)((Tree)this.delegates.stream().findAny().map(v -> (Tree)v.defaultTo(t)).orElse(null));
    }
}

