/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.git;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.openrewrite.Change;
import org.openrewrite.ChangePublisher;
import org.openrewrite.Metadata;
import org.openrewrite.git.GitMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitChangePublisher
implements ChangePublisher {
    private static final Logger logger = LoggerFactory.getLogger(GitChangePublisher.class);
    private final String user;
    private final String password;
    private final String commitMessage;

    @Override
    public void publish(Collection<Change<?>> changes) {
        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.user, this.password);
        try {
            InMemoryRepository repository = new InMemoryRepository.Builder().build();
            Git git = new Git((Repository)repository);
            git.add().addFilepattern("gradle-enterprise.xml").call();
            git.commit().setMessage(this.commitMessage).setAuthor("jkschneider", "jkschneider@gmail.com").call();
        }
        catch (IOException | GitAPIException e) {
            logger.warn("Unable to commit change", e);
        }
    }

    public void publishChangesForRepository(Collection<Change<?>> changes) {
        Change<?> change = changes.iterator().next();
        Map<Metadata, String> metadata = change.getFixed().getMetadata();
        String remote = metadata.getOrDefault(GitMetadata.REMOTE, null);
        String headCommitId = metadata.getOrDefault(GitMetadata.HEAD_COMMIT_ID, null);
        String headTreeId = metadata.getOrDefault(GitMetadata.HEAD_TREE_ID, null);
    }

    public GitChangePublisher(String user, String password, String commitMessage) {
        this.user = user;
        this.password = password;
        this.commitMessage = commitMessage;
    }
}

