/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlProfileConfigurationLoader
implements ProfileConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlProfileConfigurationLoader.class);
    private final Map<String, ProfileConfiguration> profiles = new HashMap<String, ProfileConfiguration>();

    public YamlProfileConfigurationLoader(InputStream yaml) {
        try (InputStream i = yaml;){
            Constructor constructor = new Constructor(ProfileConfiguration.class);
            TypeDescription profileDesc = new TypeDescription(ProfileConfiguration.class);
            profileDesc.substituteProperty("profile", String.class, "getName", "setName", new Class[0]);
            constructor.addTypeDescription(profileDesc);
            for (Object profileObj : new Yaml((BaseConstructor)constructor).loadAll(i)) {
                ProfileConfiguration profile = (ProfileConfiguration)profileObj;
                this.profiles.compute(profile.getName(), (name, existing) -> profile.merge((ProfileConfiguration)existing));
            }
        }
        catch (IOException e) {
            logger.warn("Unable to load YAML profile source", (Throwable)e);
        }
    }

    @Override
    public Collection<ProfileConfiguration> load() {
        return this.profiles.values();
    }
}

