/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Profile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.config.AutoConfigureSourceVisitorLoader;
import org.openrewrite.config.ClasspathProfileConfigurationLoader;
import org.openrewrite.config.ClasspathSourceVisitorLoader;
import org.openrewrite.config.ProfileConfiguration;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.SourceVisitorLoader;
import org.openrewrite.config.YamlSourceVisitorLoader;

public class RefactorPlan {
    private final Map<String, Profile> profilesByName;
    private final Collection<SourceVisitor<?>> visitors;

    public RefactorPlan(Collection<Profile> profiles, Collection<SourceVisitor<?>> visitors) {
        this.profilesByName = profiles.stream().collect(Collectors.toMap(Profile::getName, Function.identity()));
        this.visitors = visitors;
    }

    public <T extends Tree, S extends SourceVisitor<T>> Collection<S> visitors(Class<T> sourceType, String ... profiles) {
        return this.visitors(sourceType, Arrays.asList(profiles));
    }

    public <T extends Tree, S extends SourceVisitor<T>> Collection<S> visitors(Class<T> sourceType, Iterable<String> profiles) {
        List loadedProfiles = StreamSupport.stream(profiles.spliterator(), false).map(this.profilesByName::get).filter(Objects::nonNull).collect(Collectors.toList());
        return this.visitors.stream().filter(v -> {
            Type genericSuperclass = v.getClass().getGenericSuperclass();
            if (YamlSourceVisitorLoader.CompositeSourceVisitor.class.equals(v.getClass())) {
                genericSuperclass = ((YamlSourceVisitorLoader.CompositeSourceVisitor)v).getVisitorType().getGenericSuperclass();
            }
            if (genericSuperclass instanceof ParameterizedType) {
                Type[] sourceFileType = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                return sourceFileType[0].equals(sourceType);
            }
            return true;
        }).map(v -> v).map(v -> loadedProfiles.stream().reduce(v, (v2, profile) -> profile.configure(v2), (v1, v2) -> v1)).filter(v -> loadedProfiles.stream().anyMatch(p -> p.accept(v).equals((Object)Profile.FilterReply.ACCEPT))).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, ProfileConfiguration> profileConfigurations = new HashMap<String, ProfileConfiguration>();
        private final Collection<SourceVisitor<?>> visitors = new ArrayList();

        public Builder() {
            this.visitors.addAll(new AutoConfigureSourceVisitorLoader("org.openrewrite").load());
            this.visitors.addAll(new ClasspathSourceVisitorLoader().load());
        }

        public Builder scanProfiles() {
            new ClasspathProfileConfigurationLoader().load().forEach(this::loadProfile);
            return this;
        }

        public Builder scanVisitors(String ... whitelistVisitorPackages) {
            this.visitors.addAll(new AutoConfigureSourceVisitorLoader(whitelistVisitorPackages).load());
            return this;
        }

        public Builder loadVisitors(SourceVisitorLoader sourceVisitorLoader) {
            this.visitors.addAll(sourceVisitorLoader.load());
            return this;
        }

        public Builder visitor(SourceVisitor<?> visitor) {
            this.visitors.add(visitor);
            return this;
        }

        public Builder loadProfiles(ProfileConfigurationLoader profileConfigurationLoader) {
            profileConfigurationLoader.load().forEach(this::loadProfile);
            return this;
        }

        public Builder loadProfile(ProfileConfiguration profileConfiguration) {
            this.profileConfigurations.compute(profileConfiguration.getName(), (name, existing) -> profileConfiguration.merge((ProfileConfiguration)existing));
            return this;
        }

        public RefactorPlan build() {
            return new RefactorPlan(this.profileConfigurations.values().stream().map(pc -> pc.build(this.profileConfigurations.values())).collect(Collectors.toList()), this.visitors);
        }
    }
}

