/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class MapConfigSource
implements ConfigSource {
    private final Map<String, String> properties;

    public MapConfigSource(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    public String getName() {
        return "map";
    }

    public static Config mapConfig(Map<String, String> properties) {
        return ConfigProviderResolver.instance().getBuilder().addDiscoveredSources().addDiscoveredConverters().withSources(new ConfigSource[]{new MapConfigSource(properties)}).build();
    }

    public static Config mapConfig(String ... keyValues) {
        if (keyValues == null || keyValues.length == 0) {
            return MapConfigSource.emptyMapConfig();
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        HashMap<String, String> properties = new HashMap<String, String>(keyValues.length / 2);
        for (int i = 0; i < keyValues.length; i += 2) {
            properties.put(keyValues[i], keyValues[i + 1]);
        }
        return MapConfigSource.mapConfig(properties);
    }

    public static Config emptyMapConfig() {
        return MapConfigSource.mapConfig(Collections.emptyMap());
    }
}

