/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.ScanResult;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.openrewrite.Change;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.config.AutoConfigure;
import org.openrewrite.internal.lang.NonNullApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class Refactor<S extends SourceFile, T extends Tree> {
    private final Logger logger = LoggerFactory.getLogger(Refactor.class);
    private final S original;
    private MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final List<SourceVisitor<T>> visitors = new ArrayList<SourceVisitor<T>>();

    public Refactor(S original) {
        this.original = original;
    }

    @SafeVarargs
    public final Refactor<S, T> visit(SourceVisitor<T> ... visitors) {
        Collections.addAll(this.visitors, visitors);
        return this;
    }

    public final Refactor<S, T> visit(Iterable<SourceVisitor<T>> visitors) {
        visitors.forEach(this.visitors::add);
        return this;
    }

    public final Refactor<S, T> scan(Config config, String ... whitelistPackages) {
        try (ScanResult scanResult = new ClassGraph().whitelistPackages(whitelistPackages).enableMethodInfo().enableAnnotationInfo().ignoreClassVisibility().ignoreMethodVisibility().scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(AutoConfigure.class.getName())) {
                for (MethodInfo methodInfo : classInfo.getMethodInfo()) {
                    Type[] sourceFileType;
                    AnnotationInfo annotationInfo = methodInfo.getAnnotationInfo(AutoConfigure.class.getName());
                    if (annotationInfo == null) continue;
                    MethodParameterInfo[] parameterInfo = methodInfo.getParameterInfo();
                    if (parameterInfo.length != 1 || !parameterInfo[0].getTypeDescriptor().toString().equals("org.eclipse.microprofile.config.Config")) {
                        this.logger.debug("Unable to configure refactoring visitor {}#{} because it did not have a single parameter of type org.eclipse.microprofile.config.Config", (Object)classInfo.getSimpleName(), (Object)methodInfo.getName());
                        continue;
                    }
                    Method method = methodInfo.loadClassAndGetMethod();
                    Type genericSuperclass = method.getReturnType().getGenericSuperclass();
                    if (!(genericSuperclass instanceof ParameterizedType) || !(sourceFileType = ((ParameterizedType)genericSuperclass).getActualTypeArguments())[0].equals(this.original.getClass())) continue;
                    if ((methodInfo.getModifiers() & 1) == 0 || (classInfo.getModifiers() & 1) == 0) {
                        method.setAccessible(true);
                    }
                    try {
                        this.visit((SourceVisitor)method.invoke(null, config));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.logger.warn("Failed to configure refactoring visitor {}#{}", new Object[]{classInfo.getSimpleName(), methodInfo.getName(), e});
                    }
                }
            }
        }
        return this;
    }

    public final <T2 extends T> Refactor<S, T> fold(Iterable<T2> ts, Function<T2, SourceVisitor<T>> refactorForEach) {
        return StreamSupport.stream(ts.spliterator(), false).map(refactorForEach).filter(Objects::nonNull).reduce(this, (rec$, xva$0) -> ((Refactor)rec$).visit((SourceVisitor)xva$0), (r1, r2) -> r2);
    }

    public Change<S> fix() {
        return this.fix(10);
    }

    public Change<S> fix(int maxCycles) {
        Timer.Sample sample = Timer.start();
        S acc = this.original;
        HashSet<String> rulesThatMadeChanges = new HashSet<String>();
        for (int i = 0; i < maxCycles; ++i) {
            HashSet<String> rulesThatMadeChangesThisCycle = new HashSet<String>();
            for (SourceVisitor<T> visitor : this.visitors) {
                S before;
                visitor.nextCycle();
                if (!visitor.isIdempotent() && i > 0 || (before = acc) == (acc = this.transformPipeline(acc, visitor)) || visitor.getName() == null) continue;
                rulesThatMadeChangesThisCycle.add(visitor.getName());
            }
            if (rulesThatMadeChangesThisCycle.isEmpty()) break;
            rulesThatMadeChanges.addAll(rulesThatMadeChangesThisCycle);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.plan").description("The time it takes to execute a refactoring plan consisting of potentially more than one visitor over more than one cycle").tag("file.type", this.original.getFileType()).tag("outcome", rulesThatMadeChanges.isEmpty() ? "Unchanged" : "Changed").register(this.meterRegistry));
        for (String ruleThatMadeChange : rulesThatMadeChanges) {
            Counter.builder((String)"rewrite.refactor.plan.changes").description("The number of changes requested by a visitor.").tag("visitor", ruleThatMadeChange).tag("file.type", this.original.getFileType()).register(this.meterRegistry).increment();
        }
        return new Change<S>(this.original, acc, rulesThatMadeChanges);
    }

    private S transformPipeline(S acc, SourceVisitor<T> visitor) {
        Timer.Sample sample = Timer.start();
        acc = (SourceFile)visitor.visit((Tree)acc);
        for (SourceVisitor<T> vis : visitor.andThen()) {
            acc = this.transformPipeline(acc, vis);
        }
        sample.stop(Timer.builder((String)"rewrite.refactor.visit").description("The time it takes to visit a single AST with a particular refactoring visitor and its pipeline").tag("visitor", visitor.getName()).tags(visitor.getTagKeyValues()).tag("file.type", this.original.getFileType()).register(this.meterRegistry));
        return acc;
    }

    public Refactor<S, T> setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public S getOriginal() {
        return this.original;
    }

    public List<SourceVisitor<T>> getVisitors() {
        return this.visitors;
    }
}

