/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.koloboke.collect.map.hash.HashObjObjMaps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Formatting
implements Serializable {
    private static final Map<String, Map<String, Formatting>> flyweights = HashObjObjMaps.newMutableMap();
    public static Formatting EMPTY = new Formatting("", ""){

        public String toString() {
            return "Formatting{EMPTY}";
        }
    };
    private final String prefix;
    private final String suffix;

    private Formatting(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static Formatting format(String prefix) {
        return Formatting.format(prefix, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static Formatting format(@JsonProperty(value="prefix") String prefix, @JsonProperty(value="suffix") String suffix) {
        Map<String, Map<String, Formatting>> map = flyweights;
        synchronized (map) {
            if (prefix.isEmpty() && suffix.isEmpty()) {
                return EMPTY;
            }
            return flyweights.computeIfAbsent(prefix, p -> HashObjObjMaps.newMutableMap()).computeIfAbsent(suffix, s -> new Formatting(prefix, (String)s));
        }
    }

    public Formatting withPrefix(String prefix) {
        return Formatting.format(prefix, this.suffix);
    }

    public Formatting withSuffix(String suffix) {
        return Formatting.format(this.prefix, suffix);
    }

    @JsonIgnore
    public int getIndent() {
        return Formatting.getIndent(this.prefix);
    }

    public static int getIndent(String formatting) {
        int indent = 0;
        for (char c : formatting.toCharArray()) {
            if (c == '\n' || c == '\r' || !Character.isWhitespace(c)) {
                indent = 0;
                continue;
            }
            ++indent;
        }
        return indent;
    }

    public static String firstPrefix(@Nullable List<? extends Tree> trees) {
        return trees == null || trees.isEmpty() ? "" : trees.iterator().next().getFormatting().getPrefix();
    }

    public static String lastSuffix(@Nullable List<? extends Tree> trees) {
        return trees == null || trees.isEmpty() ? "" : trees.get(trees.size() - 1).getFormatting().getSuffix();
    }

    public static <T extends Tree> List<T> formatFirstPrefix(@Nullable List<T> trees, String prefix) {
        if (trees == null) {
            return null;
        }
        if (!trees.isEmpty()) {
            ArrayList<T> formattedTrees = new ArrayList<T>(trees);
            formattedTrees.set(0, ((Tree)formattedTrees.get(0)).withPrefix(prefix));
            return formattedTrees;
        }
        return trees;
    }

    public static <T extends Tree> List<T> formatLastSuffix(@Nullable List<T> trees, String suffix) {
        if (trees == null) {
            return null;
        }
        if (!trees.isEmpty()) {
            ArrayList<T> formattedTrees = new ArrayList<T>(trees);
            formattedTrees.set(formattedTrees.size() - 1, ((Tree)formattedTrees.get(formattedTrees.size() - 1)).withSuffix(suffix));
            return formattedTrees;
        }
        return trees;
    }

    public static <T extends Tree> T stripSuffix(@Nullable T t) {
        return t == null ? null : (T)t.withSuffix("");
    }

    public static <T extends Tree> T stripPrefix(@Nullable T t) {
        return t == null ? null : (T)t.withPrefix("");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

