/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;

public class Change<S extends SourceFile> {
    @Nullable
    private final S original;
    private final S fixed;
    private final Set<String> rulesThatMadeChanges;

    public Change(S original, S fixed, Set<String> rulesThatMadeChanges) {
        this.original = original;
        this.fixed = fixed;
        this.rulesThatMadeChanges = rulesThatMadeChanges;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        return new InMemoryDiffEntry(Paths.get(this.fixed.getSourcePath(), new String[0]), relativeTo, this.original == null ? "" : this.original.print(), this.fixed.print(), this.rulesThatMadeChanges).getDiff();
    }

    public S getOriginal() {
        return this.original;
    }

    public S getFixed() {
        return this.fixed;
    }

    public Set<String> getRulesThatMadeChanges() {
        return this.rulesThatMadeChanges;
    }

    static class InMemoryDiffEntry
    extends DiffEntry {
        InMemoryRepository repo;
        Set<String> rulesThatMadeChanges;

        InMemoryDiffEntry(Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<String> rulesThatMadeChanges) {
            this.changeType = DiffEntry.ChangeType.MODIFY;
            this.rulesThatMadeChanges = rulesThatMadeChanges;
            Path relativePath = relativeTo == null ? filePath : relativeTo.relativize(filePath);
            this.oldPath = relativePath.toString();
            this.newPath = relativePath.toString();
            try {
                this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
                ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();
                this.oldId = inserter.insert(3, oldSource.getBytes()).abbreviate(40);
                this.newId = inserter.insert(3, newSource.getBytes()).abbreviate(40);
                inserter.flush();
                this.oldMode = FileMode.REGULAR_FILE;
                this.newMode = FileMode.REGULAR_FILE;
                this.repo.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        String getDiff() {
            if (this.oldId.equals((Object)this.newId)) {
                return "";
            }
            ByteArrayOutputStream patch = new ByteArrayOutputStream();
            DiffFormatter formatter = new DiffFormatter((OutputStream)patch);
            formatter.setRepository((Repository)this.repo);
            try {
                formatter.format((DiffEntry)this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String diff = new String(patch.toByteArray());
            AtomicBoolean addedComment = new AtomicBoolean(false);
            return Arrays.stream(diff.split("\n")).map(l -> {
                if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                    addedComment.set(true);
                    return l + this.rulesThatMadeChanges.stream().sorted().collect(Collectors.joining(", ", " ", ""));
                }
                return l;
            }).collect(Collectors.joining("\n")) + "\n";
        }
    }
}

