/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Refactor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;

public interface RefactorModule<S extends SourceFile, T extends Tree> {
    default public Refactor<S, T> apply(Refactor<S, T> refactor) {
        return refactor;
    }

    default public List<S> getDeclaredOutputs() {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <S extends SourceFile, T extends Tree> List<Refactor<?, ?>> plan(Collection<S> sources, RefactorModule<S, T> ... modules) {
        HashSet<S> allSources = new HashSet<S>(sources);
        for (RefactorModule<S, T> module : modules) {
            allSources.addAll(module.getDeclaredOutputs());
        }
        return allSources.stream().map(s -> Arrays.stream(modules).reduce(new Refactor((SourceFile)s), (refactor, mod) -> mod.apply((Refactor)refactor), (r1, r2) -> r1)).collect(Collectors.toList());
    }
}

