/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.RecipeDependenciesExtension;
import org.openrewrite.java.internal.parser.TypeTable;

public abstract class RecipeDependenciesTypeTableTask
extends DefaultTask {
    @OutputDirectory
    public abstract DirectoryProperty getTargetDir();

    public RecipeDependenciesTypeTableTask() {
        this.getTargetDir().convention(this.getProject().getLayout().getProjectDirectory().dir("src/main/resources"));
    }

    public String getDescription() {
        return "Processes dependencies from the \"recipeDependencies\" DSL into Type Tables for use with OpenRewrite's JavaParser.";
    }

    public String getGroup() {
        return "OpenRewrite";
    }

    @TaskAction
    void download() throws IOException {
        File matchedDir = this.findMatchingDir();
        File tsvFile = this.createTsvFile(matchedDir);
        RecipeDependenciesExtension extension = (RecipeDependenciesExtension)this.getProject().getExtensions().getByType(RecipeDependenciesExtension.class);
        try (TypeTable.Writer writer = TypeTable.newWriter((OutputStream)Files.newOutputStream(tsvFile.toPath(), new OpenOption[0]));){
            for (Map.Entry<Dependency, File> dependency : extension.getResolved().entrySet()) {
                String group = Objects.requireNonNull(dependency.getKey().getGroup(), "group");
                String artifact = dependency.getKey().getName();
                String version = dependency.getValue().getName().substring(artifact.length() + 1).replaceAll(".jar$", "");
                writer.jar(group, artifact, version).write(dependency.getValue().toPath());
                this.getLogger().info("Wrote %s:%s:%s to %s".formatted(group, artifact, version, tsvFile));
            }
        }
    }

    private File findMatchingDir() {
        File targetDirFile = ((Directory)this.getTargetDir().get()).getAsFile();
        SourceDirectorySet resources = ((SourceSet)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getResources();
        Set resourcesDirs = resources.getSourceDirectories().getFiles();
        return resourcesDirs.stream().filter(dir -> dir.getAbsolutePath().equals(targetDirFile.getAbsolutePath())).findFirst().orElseThrow(() -> new GradleException("Provided target directory '" + targetDirFile.getAbsolutePath() + "' is not found in main source set resources directories. Available directories: " + String.valueOf(resourcesDirs)));
    }

    private File createTsvFile(File matchedDir) throws IOException {
        File tsvFile = new File(matchedDir, "META-INF/rewrite/classpath.tsv.gz");
        File parentFile = tsvFile.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("Unable to create " + String.valueOf(parentFile));
        }
        Files.deleteIfExists(tsvFile.toPath().resolveSibling(tsvFile.getName().replace(".tsv.gz", ".tsv.zip")));
        return tsvFile;
    }
}

