/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import com.github.jk1.license.LicenseReportExtension;
import com.github.jk1.license.LicenseReportPlugin;
import com.github.jk1.license.render.CsvReportRenderer;
import com.github.jk1.license.render.ReportRenderer;
import com.hierynomus.gradle.license.tasks.LicenseFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import nl.javadude.gradle.plugins.license.LicenseExtension;
import nl.javadude.gradle.plugins.license.LicensePlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.jvm.tasks.Jar;

public class RewriteLicensePlugin
implements Plugin<Project> {
    private static final String LICENSE_NAME = "Apache License Version 2.0";
    private static final String LICENSE_URL = "https://www.apache.org/licenses/LICENSE-2.0";

    public void apply(Project project) {
        project.getPlugins().apply(LicensePlugin.class);
        project.getPlugins().apply(LicenseReportPlugin.class);
        project.getExtensions().configure(LicenseReportExtension.class, ext -> {
            ext.renderers = new ReportRenderer[]{new CsvReportRenderer()};
        });
        project.getTasks().withType(LicenseFormat.class, task -> ((ExtraPropertiesExtension)task.getExtensions().getByName("ext")).set("year", (Object)Calendar.getInstance().get(1)));
        project.getTasks().withType(Jar.class).configureEach(jar -> jar.getManifest().attributes(Map.of("License-Name", LICENSE_NAME, "License-Url", LICENSE_URL)));
        project.getExtensions().configure(LicenseExtension.class, ext -> {
            ext.setSkipExistingHeaders(Optional.ofNullable((String)project.findProperty("licenseSkipExistingHeaders")).map(Boolean::parseBoolean).orElse(true).booleanValue());
            ext.getExcludePatterns().addAll(Arrays.asList("**/*.tokens", "**/*.config", "**/*.interp", "**/*.txt", "**/*.bat", "**/*.zip", "**/*.csv", "**/gradlew", "**/*.dontunpack", "**/*.css", "**/*.editorconfig", "**/*.md", "**/*.jar"));
            ext.setHeader(project.getRootProject().file((Object)"gradle/licenseHeader.txt"));
            ext.mapping((Map)new HashMap<String, String>(){
                {
                    this.put("kt", "SLASHSTAR_STYLE");
                    this.put("java", "SLASHSTAR_STYLE");
                    this.put("ts", "SLASHSTAR_STYLE");
                }
            });
            ext.setStrictCheck(Optional.ofNullable((String)project.findProperty("licenseStrictCheck")).map(Boolean::parseBoolean).orElse(true).booleanValue());
        });
    }
}

