/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class RecipeDependenciesExtension {
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final Set<String> dependencies = new HashSet<String>();

    @Inject
    public RecipeDependenciesExtension(ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler) {
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
    }

    public void parserClasspath(String dependencyNotation) {
        this.dependencies.add(dependencyNotation);
    }

    Map<Dependency, File> getResolved() {
        HashMap<Dependency, File> resolved = new HashMap<Dependency, File>();
        for (String dependencyNotation : this.dependencies) {
            Dependency dependency = this.dependencyHandler.create((Object)dependencyNotation);
            if (!(dependency instanceof ExternalModuleDependency)) {
                throw new IllegalArgumentException("Only external module dependencies are supported as recipe dependencies.");
            }
            ((ExternalModuleDependency)dependency).setTransitive(false);
            for (File file : this.configurationContainer.detachedConfiguration(new Dependency[]{dependency}).resolve()) {
                resolved.put(dependency, file);
            }
        }
        return resolved;
    }
}

