/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Map;
import nebula.plugin.publishing.maven.MavenBasePublishPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.jvm.tasks.Jar;
import org.jspecify.annotations.Nullable;

public class ModerneProprietaryLicensePlugin
implements Plugin<Project> {
    private static final String LICENSE_NAME = "Moderne Proprietary License";
    private static final String LICENSE_URL = "https://docs.moderne.io/licensing/overview";

    public void apply(Project project) {
        Jar emptySourcesJar;
        Task sourcesJar = (Task)project.getTasks().findByName("sourcesJar");
        if (sourcesJar != null) {
            sourcesJar.setEnabled(false);
            emptySourcesJar = (Jar)project.getTasks().create("emptySourceJar", Jar.class, task -> {
                task.from(new Object[]{"README.md"});
                task.getArchiveClassifier().set((Object)"sources");
            });
            project.getTasks().named("assemble", task -> task.dependsOn(new Object[]{emptySourcesJar}));
        } else {
            emptySourcesJar = null;
        }
        project.getPlugins().apply(MavenBasePublishPlugin.class);
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        publishing.publications(publications -> publications.withType(MavenPublication.class, p -> this.configureLicense((MavenPublication)p, emptySourcesJar)));
        project.getTasks().withType(Jar.class).configureEach(jar -> jar.getManifest().attributes(Map.of("License-Name", LICENSE_NAME, "License-Url", LICENSE_URL)));
    }

    private void configureLicense(MavenPublication publication, @Nullable Jar sourcesJar) {
        if (sourcesJar != null) {
            publication.artifact((Object)sourcesJar);
        }
        publication.pom(pom -> pom.licenses(licenses -> licenses.license(license -> {
            ((DefaultMavenPom)licenses).getLicenses().clear();
            license.getName().set((Object)LICENSE_NAME);
            license.getUrl().set((Object)LICENSE_URL);
        })));
    }
}

