/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.PatternVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.RecipeDependenciesExtension;

public class RecipeDependenciesDownloadTask
extends DefaultTask {
    private static final ChainVersionMatcher versionMatcher = new ChainVersionMatcher();

    public String getDescription() {
        return "Download dependencies from the \"recipeDependencies\" DSL and making, them available with OpenRewrite's JavaParser. Generally speaking type tables generated by the task \"generateTypeTables\" are preferable to this approach.";
    }

    public String getGroup() {
        return "OpenRewrite";
    }

    @TaskAction
    void download() throws IOException {
        SourceDirectorySet resources = ((SourceSet)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getResources();
        for (File sourceDirectory : resources.getSourceDirectories()) {
            File parserClasspath = new File(sourceDirectory, "META-INF/rewrite/classpath");
            if (!parserClasspath.exists() && !parserClasspath.mkdirs()) {
                throw new IllegalStateException("Unable to create directory " + String.valueOf(parserClasspath));
            }
            RecipeDependenciesExtension extension = (RecipeDependenciesExtension)this.getProject().getExtensions().getByType(RecipeDependenciesExtension.class);
            for (Map.Entry<Dependency, File> dependency : extension.getResolved().entrySet()) {
                Path dependencyFile = dependency.getValue().toPath();
                Path destination = parserClasspath.toPath().resolve(dependencyFile.getFileName());
                if (Files.exists(destination, new LinkOption[0])) continue;
                for (File otherDependency : Objects.requireNonNull(parserClasspath.listFiles())) {
                    if (!RecipeDependenciesDownloadTask.shouldReplace(dependency.getKey(), otherDependency.getName())) continue;
                    Files.delete(otherDependency.toPath());
                }
                Files.copy(dependencyFile, destination, new CopyOption[0]);
            }
        }
    }

    static boolean shouldReplace(Dependency dependency, String otherName) {
        try {
            return otherName.startsWith(dependency.getName()) && versionMatcher.accept(ModuleRevisionId.newInstance((String)"group", (String)"artifact", (String)Objects.requireNonNull(dependency.getVersion())), ModuleRevisionId.newInstance((String)"group", (String)"name", (String)otherName.substring(dependency.getName().length() + 1)));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to check for replacement of " + String.valueOf(dependency) + " with " + otherName, t);
        }
    }

    static {
        versionMatcher.add((VersionMatcher)new ExactVersionMatcher());
        versionMatcher.add((VersionMatcher)new LatestVersionMatcher());
        versionMatcher.add((VersionMatcher)new PatternVersionMatcher());
        versionMatcher.add((VersionMatcher)new SubVersionMatcher());
        versionMatcher.add((VersionMatcher)new VersionRangeMatcher("latest", (LatestStrategy)new LatestLexicographicStrategy()));
    }
}

