/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.openrewrite.gradle.RecipeExamplesTask;

public class RewriteRecipeExamplesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        File srcDir = new File(project.getProjectDir(), "src");
        if (!srcDir.exists()) {
            return;
        }
        TaskProvider extractExamples = project.getTasks().register("extractRecipeExamples", RecipeExamplesTask.class, task -> task.setSources(srcDir));
        TaskProvider copyExamples = project.getTasks().register("copyExamples", Copy.class);
        project.getTasks().named("classes").configure(task -> task.dependsOn(new Object[]{copyExamples}));
        copyExamples.configure(task -> {
            task.dependsOn(new Object[]{extractExamples});
            task.from(new Object[]{((RecipeExamplesTask)((Object)((Object)extractExamples.get()))).getOutputDirectory()});
            task.into((Object)new File(project.getBuildDir(), "resources/main/META-INF/rewrite/examples"));
        });
    }
}

