/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.RecipeDependenciesExtension;
import org.openrewrite.java.internal.parser.TypeTable;

public class RecipeDependenciesTypeTableTask
extends DefaultTask {
    public String getDescription() {
        return "Processes dependencies from the \"recipeDependencies\" DSL into Type Tables for use with OpenRewrite's JavaParser.";
    }

    public String getGroup() {
        return "OpenRewrite";
    }

    @TaskAction
    void download() throws IOException {
        SourceDirectorySet resources = ((SourceSet)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getResources();
        for (File sourceDirectory : resources.getSourceDirectories()) {
            File tsvFile = new File(sourceDirectory, "META-INF/rewrite/classpath.tsv.zip");
            File parentFile = tsvFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IllegalStateException("Unable to create " + String.valueOf(parentFile));
            }
            RecipeDependenciesExtension extension = (RecipeDependenciesExtension)this.getProject().getExtensions().getByType(RecipeDependenciesExtension.class);
            TypeTable.Writer writer = TypeTable.newWriter((OutputStream)Files.newOutputStream(tsvFile.toPath(), new OpenOption[0]));
            try {
                for (Map.Entry<Dependency, File> dependency : extension.getResolved().entrySet()) {
                    String group = Objects.requireNonNull(dependency.getKey().getGroup(), "group");
                    String artifact = dependency.getKey().getName();
                    String version = dependency.getValue().getName().substring(artifact.length() + 1).replaceAll(".jar$", "");
                    writer.jar(group, artifact, version).write(dependency.getValue().toPath());
                    this.getLogger().info(String.format("Wrote %s:%s:%s to %s", group, artifact, version, tsvFile));
                }
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }
}

