/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.PersonIdent;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public class RewriteRecipeAuthorAttributionTask
extends DefaultTask {
    private final DirectoryProperty sources = this.getProject().getObjects().directoryProperty();
    private Set<URI> classpath;

    public void setSources(File sourceDirectory) {
        this.sources.set(sourceDirectory);
    }

    @SkipWhenEmpty
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @IgnoreEmptyDirectories
    public DirectoryProperty getSources() {
        return this.sources;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath.getFiles().stream().map(File::toURI).collect(Collectors.toSet());
    }

    @Internal
    public Set<URI> getClasspath() {
        return this.classpath;
    }

    @OutputDirectory
    public Path getOutputDirectory() {
        return this.getProject().getBuildDir().toPath().resolve("rewrite/attribution").resolve(((Directory)this.sources.get()).getAsFile().getName());
    }

    @TaskAction
    void execute(InputChanges inputChanges) {
        try (Git g = Git.open((File)this.getProject().getRootDir());){
            HashMap<String, String> recipeFileNameToFqn = new HashMap<String, String>();
            try (ScanResult scanResult = new ClassGraph().enableClassInfo().overrideClasspath(this.classpath).scan();){
                ClassInfoList recipeClasses = scanResult.getSubclasses("org.openrewrite.Recipe");
                for (ClassInfo recipeClass : recipeClasses) {
                    recipeFileNameToFqn.put(recipeClass.getSourceFile(), recipeClass.getName());
                }
            }
            YAMLMapper mapper = new YAMLMapper();
            Path outputDir = this.getOutputDirectory();
            for (FileChange change : inputChanges.getFileChanges((Provider)this.sources)) {
                File recipeFile = change.getFile();
                String recipeFqn = (String)recipeFileNameToFqn.get(recipeFile.getName());
                if (recipeFqn == null) continue;
                Path targetPath = outputDir.resolve(recipeFqn + ".yml");
                if (change.getChangeType() == ChangeType.REMOVED) {
                    Files.delete(targetPath);
                    continue;
                }
                String relativePath = this.getProject().getRootDir().toPath().relativize(recipeFile.toPath()).toString().replace('\\', '/');
                List<Contributor> contributors = RewriteRecipeAuthorAttributionTask.listContributors(g, relativePath);
                Attribution attribution = new Attribution("specs.openrewrite.org/v1beta/attribution", recipeFqn, contributors);
                String yaml = mapper.writeValueAsString((Object)attribution);
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                Files.write(targetPath, yaml.getBytes(), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to complete attribution of recipe authors", (Throwable)e);
        }
    }

    private static List<Contributor> listContributors(Git g, String relativeUnixStylePath) throws GitAPIException {
        HashMap<Contributor, Integer> contributors = new HashMap<Contributor, Integer>();
        BlameResult blame = g.blame().setFilePath(relativeUnixStylePath).call();
        RawText resultContents = blame.getResultContents();
        if (resultContents == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < resultContents.size(); ++i) {
            PersonIdent author = blame.getSourceAuthor(i);
            contributors.compute(new Contributor(author.getName(), author.getEmailAddress(), 0), (k, v) -> v == null ? 1 : v + 1);
        }
        return Contributor.distinct(contributors.entrySet().stream().map(entry -> ((Contributor)entry.getKey()).withLineCount((Integer)entry.getValue())).sorted(Comparator.comparing(Contributor::getLineCount).reversed()).collect(Collectors.toList()));
    }

    static final class Attribution {
        private final String type;
        private final String recipeName;
        private final List<Contributor> contributors;

        @Generated
        public Attribution(String type, String recipeName, List<Contributor> contributors) {
            this.type = type;
            this.recipeName = recipeName;
            this.contributors = contributors;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getRecipeName() {
            return this.recipeName;
        }

        @Generated
        public List<Contributor> getContributors() {
            return this.contributors;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribution)) {
                return false;
            }
            Attribution other = (Attribution)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$recipeName = this.getRecipeName();
            String other$recipeName = other.getRecipeName();
            if (this$recipeName == null ? other$recipeName != null : !this$recipeName.equals(other$recipeName)) {
                return false;
            }
            List<Contributor> this$contributors = this.getContributors();
            List<Contributor> other$contributors = other.getContributors();
            return !(this$contributors == null ? other$contributors != null : !((Object)this$contributors).equals(other$contributors));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $recipeName = this.getRecipeName();
            result = result * 59 + ($recipeName == null ? 43 : $recipeName.hashCode());
            List<Contributor> $contributors = this.getContributors();
            result = result * 59 + ($contributors == null ? 43 : ((Object)$contributors).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RewriteRecipeAuthorAttributionTask.Attribution(type=" + this.getType() + ", recipeName=" + this.getRecipeName() + ", contributors=" + this.getContributors() + ")";
        }
    }

    static final class Contributor {
        private final String name;
        private final String email;
        private final int lineCount;

        public static List<Contributor> distinct(List<Contributor> contribs) {
            ArrayList<Contributor> deduped = new ArrayList<Contributor>(contribs.size());
            for (Contributor contrib : contribs) {
                if (!deduped.stream().noneMatch(c -> c.getEmail().equals(contrib.getEmail()))) continue;
                deduped.add(contrib);
            }
            LinkedHashMap<String, Contributor> byName = new LinkedHashMap<String, Contributor>(deduped.size());
            for (Contributor contributor : deduped) {
                String name = contributor.getName();
                if (byName.containsKey(name)) {
                    if (!((Contributor)byName.get(name)).getEmail().endsWith("@users.noreply.github.com")) continue;
                    byName.put(name, contributor);
                    continue;
                }
                byName.put(name, contributor);
            }
            return new ArrayList<Contributor>(byName.values());
        }

        @Generated
        public Contributor(String name, String email, int lineCount) {
            this.name = name;
            this.email = email;
            this.lineCount = lineCount;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public int getLineCount() {
            return this.lineCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Contributor)) {
                return false;
            }
            Contributor other = (Contributor)o;
            if (this.getLineCount() != other.getLineCount()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineCount();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RewriteRecipeAuthorAttributionTask.Contributor(name=" + this.getName() + ", email=" + this.getEmail() + ", lineCount=" + this.getLineCount() + ")";
        }

        @Generated
        public Contributor withLineCount(int lineCount) {
            return this.lineCount == lineCount ? this : new Contributor(this.name, this.email, lineCount);
        }
    }
}

