/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.ExamplesExtractor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParser;

public class RecipeExamplesTask
extends DefaultTask {
    private final DirectoryProperty sources = this.getProject().getObjects().directoryProperty();

    @SkipWhenEmpty
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @IgnoreEmptyDirectories
    public DirectoryProperty getSources() {
        return this.sources;
    }

    public void setSources(File sourceDirectory) {
        this.sources.set(sourceDirectory);
    }

    @OutputDirectory
    public Path getOutputDirectory() {
        return this.getProject().getBuildDir().toPath().resolve("rewrite/examples").resolve(((Directory)this.sources.get()).getAsFile().getName());
    }

    @TaskAction
    void execute() {
        ArrayList<File> allJavaFiles = new ArrayList<File>();
        this.collectFiles(((Directory)this.sources.get()).getAsFile(), allJavaFiles);
        try {
            this.extractExamples(allJavaFiles, (ExecutionContext)new InMemoryExecutionContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().lifecycle("Extract examples fail");
        }
    }

    private void collectFiles(File directory, List<File> allJavaFiles) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.collectFiles(file, allJavaFiles);
                    continue;
                }
                if (!file.getName().endsWith(".java")) continue;
                allJavaFiles.add(file);
            }
        }
    }

    private void extractExamples(List<File> allJavaFiles, ExecutionContext ctx) {
        JavaParser parser = JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath()).build();
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>();
        for (File file : allJavaFiles) {
            Parser.Input input = new Parser.Input(file.toPath(), () -> {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            inputs.add(input);
        }
        this.getLogger().lifecycle("Parsing " + allJavaFiles.size() + " java files...");
        List sourceFiles = parser.parseInputs(inputs, null, ctx).collect(Collectors.toList());
        int resultCount = 0;
        this.getLogger().lifecycle("Parsing java files finished.");
        for (SourceFile s : sourceFiles) {
            ExamplesExtractor examplesExtractor = new ExamplesExtractor();
            try {
                examplesExtractor.visit((Tree)s, ctx);
                String yamlContent = examplesExtractor.printRecipeExampleYaml();
                if (!StringUtils.isNotEmpty((String)yamlContent)) continue;
                ++resultCount;
                this.writeYamlFile(s.getSourcePath().getFileName().toString(), this.getOutputDirectory(), yamlContent);
            }
            catch (Exception e) {
                this.getLogger().error("Parsing file {} failed.", (Object)s.getSourcePath().getFileName().toString());
            }
        }
        this.getLogger().lifecycle("Generated " + resultCount + " recipe examples yaml files");
    }

    void writeYamlFile(String originalTestFileName, Path outputPath, String data) {
        int index = originalTestFileName.lastIndexOf(46);
        String nameWithoutExtension = index == -1 ? originalTestFileName : originalTestFileName.substring(0, index);
        String fileName = nameWithoutExtension + ".yml";
        Path path = Paths.get(outputPath.toString(), fileName);
        try {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(path, new LinkOption[0])) {
                return;
            }
            FileWriter writer = new FileWriter(path.toFile());
            writer.write(data);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

