/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PathUtils;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ExamplesExtractor
extends JavaIsoVisitor<ExecutionContext> {
    private static final AnnotationMatcher TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher DOCUMENT_EXAMPLE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.openrewrite.DocumentExample");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER_WITH_SPEC = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(java.util.function.Consumer, org.openrewrite.test.SourceSpecs[])");
    private static final MethodMatcher REWRITE_RUN_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.RewriteTest rewriteRun(org.openrewrite.test.SourceSpecs[])");
    private static final MethodMatcher JAVA_METHOD_MATCHER = new MethodMatcher("org.openrewrite.java.Assertions java(..)");
    private static final MethodMatcher BUILD_GRADLE_METHOD_MATCHER = new MethodMatcher("org.openrewrite.gradle.Assertions buildGradle(..)");
    private static final MethodMatcher POM_XML_METHOD_MATCHER = new MethodMatcher("org.openrewrite.maven.Assertions pomXml(..)");
    private static final MethodMatcher XML_METHOD_MATCHER = new MethodMatcher("org.openrewrite.xml.Assertions xml(..)");
    private static final MethodMatcher YAML_METHOD_MATCHER = new MethodMatcher("org.openrewrite.yaml.Assertions yaml(..)");
    private static final MethodMatcher PROTOBUF_METHOD_MATCHER = new MethodMatcher("org.openrewrite.protobuf.proto.Assertions proto(..)");
    private static final MethodMatcher PROPERTIES_METHOD_MATCHER = new MethodMatcher("org.openrewrite.properties.Assertions properties(..)");
    private static final MethodMatcher JSON_METHOD_MATCHER = new MethodMatcher("org.openrewrite.json.Assertions json(..)");
    private static final MethodMatcher HCL_METHOD_MATCHER = new MethodMatcher("org.openrewrite.hcl.Assertions hcl(..)");
    private static final MethodMatcher GROOVY_METHOD_MATCHER = new MethodMatcher("org.openrewrite.groovy.Assertions groovy(..)");
    private static final MethodMatcher KOTLIN_METHOD_MATCHER = new MethodMatcher("org.openrewrite.kotlin.Assertions kotlin(..)");
    private static final MethodMatcher ACTIVE_RECIPES_METHOD_MATCHER = new MethodMatcher("org.openrewrite.config.Environment activateRecipes(..)");
    private static final MethodMatcher PATH_METHOD_MATCHER = new MethodMatcher("org.openrewrite.test.SourceSpec path(java.lang.String)");
    private final String recipeType;
    private RecipeNameAndParameters defaultRecipe = new RecipeNameAndParameters();
    private RecipeNameAndParameters specifiedRecipe = new RecipeNameAndParameters();
    private final List<RecipeExample> recipeExamples = new ArrayList<RecipeExample>();
    private String exampleDescription = "";

    public ExamplesExtractor() {
        this.recipeType = "specs.openrewrite.org/v1beta/example";
    }

    public String printRecipeExampleYaml() {
        boolean usingDefaultRecipe = !this.specifiedRecipe.isValid();
        return new YamlPrinter().print(this.recipeType, usingDefaultRecipe ? this.defaultRecipe : this.specifiedRecipe, usingDefaultRecipe, this.recipeExamples);
    }

    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
        if (method.getName().getSimpleName().equals("defaults") && method.getMethodType() != null && !method.getMethodType().getDeclaringType().getInterfaces().isEmpty() && ((JavaType.FullyQualified)method.getMethodType().getDeclaringType().getInterfaces().get(0)).getFullyQualifiedName().equals("org.openrewrite.test.RewriteTest")) {
            this.defaultRecipe = this.findRecipe((J)method);
            return method;
        }
        List annotations = method.getLeadingAnnotations();
        if (ExamplesExtractor.hasNotAnnotation(annotations, TEST_ANNOTATION_MATCHER) || ExamplesExtractor.hasNotAnnotation(annotations, DOCUMENT_EXAMPLE_ANNOTATION_MATCHER)) {
            return method;
        }
        new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
                List args;
                if (DOCUMENT_EXAMPLE_ANNOTATION_MATCHER.matches(annotation) && (args = annotation.getArguments()) != null && args.size() == 1) {
                    Expression arg = (Expression)args.get(0);
                    if (arg instanceof J.Assignment) {
                        J.Assignment assignment = (J.Assignment)args.get(0);
                        if (assignment.getAssignment() instanceof J.Literal) {
                            ExamplesExtractor.this.exampleDescription = (String)((J.Literal)assignment.getAssignment()).getValue();
                        }
                    } else if (arg instanceof J.Literal) {
                        ExamplesExtractor.this.exampleDescription = (String)((J.Literal)args.get(0)).getValue();
                    }
                }
                return annotation;
            }
        }.visit((Tree)method, (Object)ctx);
        return super.visitMethodDeclaration(method, (Object)ctx);
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        int sourceStartIndex;
        List args = method.getArguments();
        RecipeExample example = new RecipeExample();
        RecipeNameAndParameters recipe = null;
        if (REWRITE_RUN_METHOD_MATCHER_WITH_SPEC.matches((MethodCall)method)) {
            recipe = this.findRecipe((J)args.get(0));
            if (recipe != null) {
                this.specifiedRecipe = recipe;
            }
            sourceStartIndex = 1;
        } else if (REWRITE_RUN_METHOD_MATCHER.matches((MethodCall)method)) {
            sourceStartIndex = 0;
        } else {
            return method;
        }
        for (int i = sourceStartIndex; i < args.size(); ++i) {
            RecipeExample.Source source = this.extractRecipeExampleSource((Expression)args.get(i));
            if (source == null) continue;
            example.getSources().add(source);
        }
        if (!example.getSources().isEmpty()) {
            example.setDescription(this.exampleDescription);
            example.setParameters(recipe != null ? recipe.getParameters() : (this.defaultRecipe != null ? this.defaultRecipe.getParameters() : new ArrayList()));
            this.recipeExamples.add(example);
        }
        return method;
    }

    private static boolean hasNotAnnotation(List<J.Annotation> annotations, AnnotationMatcher matcher) {
        return annotations.stream().noneMatch(arg_0 -> ((AnnotationMatcher)matcher).matches(arg_0));
    }

    @Nullable
    private RecipeNameAndParameters findRecipe(final J tree) {
        return (RecipeNameAndParameters)((AtomicReference)new JavaIsoVisitor<AtomicReference<RecipeNameAndParameters>>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, final AtomicReference<RecipeNameAndParameters> recipe) {
                if (ExamplesExtractor.isRecipeSpecRecipeMethod(method)) {
                    new JavaIsoVisitor<AtomicReference<RecipeNameAndParameters>>(){

                        public J.NewClass visitNewClass(J.NewClass newClass, AtomicReference<RecipeNameAndParameters> recipe2) {
                            JavaType type;
                            JavaType javaType = type = newClass.getClazz() != null ? newClass.getClazz().getType() : null;
                            if (type == null) {
                                type = newClass.getType();
                            }
                            if (TypeUtils.isAssignableTo((String)"org.openrewrite.Recipe", (JavaType)type) && type instanceof JavaType.Class) {
                                JavaType.Class tc = (JavaType.Class)type;
                                RecipeNameAndParameters recipeNameAndParameters = new RecipeNameAndParameters();
                                recipeNameAndParameters.setName(tc.getFullyQualifiedName());
                                recipeNameAndParameters.setParameters(ExamplesExtractor.extractParameters(newClass.getArguments()));
                                recipe2.set(recipeNameAndParameters);
                            }
                            return newClass;
                        }

                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicReference<RecipeNameAndParameters> recipeNameAndParametersAtomicReference) {
                            if (ACTIVE_RECIPES_METHOD_MATCHER.matches((MethodCall)method)) {
                                Expression arg = (Expression)method.getArguments().get(0);
                                if (arg instanceof J.Literal && ((J.Literal)arg).getValue() != null) {
                                    RecipeNameAndParameters recipeNameAndParameters = new RecipeNameAndParameters();
                                    recipeNameAndParameters.setName(((J.Literal)arg).getValue().toString());
                                    recipe.set(recipeNameAndParameters);
                                }
                                return method;
                            }
                            return super.visitMethodInvocation(method, recipeNameAndParametersAtomicReference);
                        }
                    }.visit((Tree)tree, recipe);
                }
                return super.visitMethodInvocation(method, recipe);
            }
        }.reduce((Tree)tree, new AtomicReference())).get();
    }

    private static List<String> extractParameters(List<Expression> args) {
        return args.stream().map(arg -> {
            if (arg instanceof J.Empty) {
                return null;
            }
            if (arg instanceof J.Literal) {
                J.Literal literal = (J.Literal)arg;
                if (literal.getValue() != null) {
                    return literal.getValue().toString();
                }
                return ((J.Literal)arg).getValueSource();
            }
            return arg.toString();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private RecipeExample.Source extractRecipeExampleSource(Expression sourceSpecArg) {
        RecipeExample.Source source = new RecipeExample.Source("", null, null, "");
        new JavaIsoVisitor<RecipeExample.Source>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, RecipeExample.Source source) {
                J.Literal after;
                J.Literal before;
                String language;
                method = super.visitMethodInvocation(method, (Object)source);
                if (JAVA_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "java";
                } else if (BUILD_GRADLE_METHOD_MATCHER.matches((MethodCall)method)) {
                    source.setPath("build.gradle");
                    language = "groovy";
                } else if (POM_XML_METHOD_MATCHER.matches((MethodCall)method)) {
                    source.setPath("pom.xml");
                    language = "xml";
                } else if (XML_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "xml";
                } else if (YAML_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "yaml";
                } else if (PROTOBUF_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "protobuf";
                } else if (PROPERTIES_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "properties";
                } else if (JSON_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "json";
                } else if (HCL_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "hcl";
                } else if (GROOVY_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "groovy";
                } else if (KOTLIN_METHOD_MATCHER.matches((MethodCall)method)) {
                    language = "kotlin";
                } else {
                    if (PATH_METHOD_MATCHER.matches((MethodCall)method)) {
                        if (method.getArguments().get(0) instanceof J.Literal) {
                            source.setPath((String)((J.Literal)method.getArguments().get(0)).getValue());
                        }
                        return method;
                    }
                    return method;
                }
                source.setLanguage(language);
                List args = method.getArguments();
                J.Literal literal = !args.isEmpty() ? (args.get(0) instanceof J.Literal ? (J.Literal)args.get(0) : null) : (before = null);
                J.Literal literal2 = args.size() > 1 ? (args.get(1) instanceof J.Literal ? (J.Literal)args.get(1) : null) : (after = null);
                if (before != null && before.getValue() != null) {
                    source.setBefore((String)before.getValue());
                }
                if (after != null) {
                    source.setAfter((String)after.getValue());
                }
                if (StringUtils.isNullOrEmpty((String)source.getPath())) {
                    source.getBefore();
                    source.setPath(ExamplesExtractor.this.getPath(source.getBefore(), language));
                }
                return method;
            }
        }.visit((Tree)sourceSpecArg, (Object)source);
        if (StringUtils.isNotEmpty((String)source.getBefore()) || StringUtils.isNotEmpty((String)source.getAfter())) {
            return source;
        }
        return null;
    }

    @Nullable
    String getPath(@Nullable @Language(value="java") String content, String language) {
        if (content == null) {
            return null;
        }
        if (language.equals("java")) {
            try {
                Stream cusStream = JavaParser.fromJavaVersion().build().parse(new String[]{content});
                Optional firstElement = cusStream.findFirst();
                if (firstElement.isPresent()) {
                    return ((SourceFile)firstElement.get()).getSourcePath().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isRecipeSpecRecipeMethod(J.MethodInvocation method) {
        return "recipe".equals(method.getName().getSimpleName()) && method.getSelect() != null && TypeUtils.isOfClassType((JavaType)method.getSelect().getType(), (String)"org.openrewrite.test.RecipeSpec");
    }

    private static class RecipeNameAndParameters {
        String name = "";
        List<String> parameters = new ArrayList<String>();

        boolean isValid() {
            return StringUtils.isNotEmpty((String)this.name);
        }

        @Generated
        public RecipeNameAndParameters() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<String> getParameters() {
            return this.parameters;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setParameters(List<String> parameters) {
            this.parameters = parameters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecipeNameAndParameters)) {
                return false;
            }
            RecipeNameAndParameters other = (RecipeNameAndParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$parameters = this.getParameters();
            List<String> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RecipeNameAndParameters;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExamplesExtractor.RecipeNameAndParameters(name=" + this.getName() + ", parameters=" + this.getParameters() + ")";
        }
    }

    public static class YamlPrinter {
        String print(String recipeType, @Nullable RecipeNameAndParameters recipe, boolean usingDefaultRecipe, List<RecipeExample> examples) {
            if (recipe == null || StringUtils.isNullOrEmpty((String)recipe.getName()) || examples.isEmpty()) {
                return "";
            }
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
            data.put("type", recipeType);
            data.put("recipeName", recipe.getName());
            ArrayList examplesData = new ArrayList();
            for (RecipeExample example : examples) {
                List params;
                LinkedHashMap<String, Object> exampleData = new LinkedHashMap<String, Object>();
                example.getDescription();
                exampleData.put("description", example.getDescription());
                List list = params = usingDefaultRecipe ? recipe.getParameters() : example.getParameters();
                if (params != null && !params.isEmpty()) {
                    exampleData.put("parameters", params);
                }
                ArrayList sourcesData = new ArrayList();
                for (RecipeExample.Source source : example.getSources()) {
                    LinkedHashMap<String, String> sourceData = new LinkedHashMap<String, String>();
                    if (StringUtils.isNotEmpty((String)source.getBefore())) {
                        sourceData.put("before", source.getBefore());
                    }
                    if (StringUtils.isNotEmpty((String)source.getAfter())) {
                        sourceData.put("after", source.getAfter());
                    }
                    if (StringUtils.isNotEmpty((String)source.getPath())) {
                        sourceData.put("path", PathUtils.separatorsToUnix((String)source.getPath()));
                    }
                    if (StringUtils.isNotEmpty((String)source.getLanguage())) {
                        sourceData.put("language", source.getLanguage());
                    }
                    sourcesData.add(sourceData);
                }
                exampleData.put("sources", sourcesData);
                examplesData.add(exampleData);
            }
            data.put("examples", examplesData);
            Yaml yaml = new Yaml();
            return yaml.dumpAsMap(data);
        }
    }
}

