/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.camel46;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.upgrade.AbstractCamelXmlVisitor;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class XmlDsl46Recipe
extends Recipe {
    private static final XPathMatcher BEAN_PROPERTY_XPATH_MATCHER = new XPathMatcher("bean/property");
    private static final XPathMatcher BEAN_XPATH_MATCHER = new XPathMatcher("bean");

    public String getDisplayName() {
        return "Camel XMl DSL changes";
    }

    public String getDescription() {
        return "Apache Camel XML DSL migration from version 3.20 or higher to 4.0.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelXmlVisitor(){

            @Override
            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Xml.Tag doVisitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.doVisitTag(tag, ctx);
                if (BEAN_PROPERTY_XPATH_MATCHER.matches(this.getCursor())) {
                    LinkedList<Xml.Tag> sb = (LinkedList<Xml.Tag>)this.getCursor().getParent().getMessage("properties");
                    if (sb == null) {
                        sb = new LinkedList<Xml.Tag>();
                        this.getCursor().getParent().putMessage("properties", sb);
                        this.getCursor().getParent().putMessage("propertiesPrefix", (Object)t.getPrefix());
                    }
                    sb.add(t.withPrefix(t.getPrefix() + "  "));
                    return null;
                }
                if (BEAN_XPATH_MATCHER.matches(this.getCursor()) && this.getCursor().getMessage("properties") != null) {
                    List sb = (List)this.getCursor().getMessage("properties");
                    String prefix = (String)this.getCursor().getMessage("propertiesPrefix");
                    if (sb != null) {
                        LinkedList<Xml.Tag> content = new LinkedList<Xml.Tag>();
                        content.addAll(t.getContent());
                        content.add(Xml.Tag.build((String)"<properties/>").withPrefix(prefix).withContent(sb));
                        return t.withContent(content);
                    }
                }
                return t;
            }
        };
    }
}

