/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.UpdateMavenProjectPropertyJavaVersion;
import org.openrewrite.maven.UseMavenCompilerPluginReleaseConfiguration;

public class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="17")
    Integer version;

    public String getDisplayName() {
        return "Upgrade Java version";
    }

    public String getDescription() {
        return "Upgrade build plugin configuration to use the specified Java version. This recipe changes `java.toolchain.languageVersion` in `build.gradle(.kts)` of gradle projects, or maven-compiler-plugin target version and related settings. Will not downgrade if the version is newer than the specified version.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new UseMavenCompilerPluginReleaseConfiguration(this.version), new UpdateMavenProjectPropertyJavaVersion(this.version));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(0L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String newVersion = this.version.toString();
        final HashMap updatedMarkers = new HashMap();
        return new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                Optional maybeJavaVersion = tree.getMarkers().findFirst(JavaVersion.class);
                if (maybeJavaVersion.isPresent() && ((JavaVersion)maybeJavaVersion.get()).getMajorVersion() < UpgradeJavaVersion.this.version) {
                    return (J)tree.withMarkers(tree.getMarkers().setByType((Marker)updatedMarkers.computeIfAbsent((JavaVersion)maybeJavaVersion.get(), m -> m.withSourceCompatibility(newVersion).withTargetCompatibility(newVersion))));
                }
                return tree;
            }
        };
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }
}

